@extends('schoolLayout.app')
@section('content')
    <style>
        /* Increase height of the Select2 container */
        .custom-select2+.select2-container .select2-selection--single {
            height: 38px !important;
            display: flex;
            align-items: center;
            border-radius: 0.375rem;
            /* Tailwind's rounded */
            border: 1px solid #d1d5db;
            /* Tailwind gray-300 */
            padding-left: 0.75rem;
            padding-right: 0.75rem;
        }

        /* Optional: increase font size */
        .custom-select2+.select2-container .select2-selection__rendered {
            font-size: 16px;
            line-height: 48px;
        }
    </style>
    @include('successError')
    <div class="flex justify-between items-center  pb-4">
        @include('salary.partialHead')
    </div>
    <div class="border border-gray-200 rounded-lg">
        <!-- Search and Filters -->
        <div class="flex items-center mt-4 space-x-4">

            <select id="staff-search" name="staff-search" class="border p-2 rounded-lg  select2 custom-select2">
                <option value="all">All Staff</option>
                @foreach ($staffs as $s)
                    <option value="{{ $s->head_code }}">
                        {{ $s->full_name }} - {{ $s->registration_no }}
                    </option>
                @endforeach
            </select>
            <a href="{{ route('pdf.salary.list') }}" target="_blank"
                class="bg-[#0197FF] text-white px-4 py-2 rounded-lg hover:bg-blue-600">
                DF
            </a>

        </div>
        <div id="staff-table" class="rounded-lg relative">
            @include('salary.partialSalaryList')

        </div>

    </div>

    @include('salary.component', ['staffs' => $staffList])
    <!-- Salary Update Modal -->
    <div id="updateSalaryRow" class="fixed inset-0 z-50 bg-black bg-opacity-30 hidden flex items-center justify-center">
        <div class="bg-white p-6 rounded-lg shadow-md w-full max-w-4xl">
            <h2 class="text-xl font-bold mb-4">Update Salary</h2>
            <form id="updateSalaryForm" action="{{ route('salary.row.update') }}" method="POST"
                class="grid grid-cols-1 md:grid-cols-3 gap-4">
                @csrf
                <input type="hidden" name="staff_id" id="modalStaffId">

                <div class="mb-2 col-span-1">
                    <label>Employee Name:</label>
                    <input type="text" id="m_FullName" name="m_FullName" class="w-full border px-3 py-1" readonly>
                </div>

                <div class="mb-2 col-span-1">
                    <label>Head Code:</label>
                    <input type="text" id="m_HeadCode" name="m_HeadCode" class="w-full border px-3 py-1" readonly>
                </div>

                <div class="mb-2 col-span-1">
                    <label>Reg No:</label>
                    <input type="text" id="m_RegNo" name="m_RegNo" class="w-full border px-3 py-1" readonly>
                </div>

                <div class="mb-2 col-span-1">
                    <label>Salary:</label>
                    <input type="number" name="m_Salary" id="m_Salary" class="w-full border px-3 py-1">
                </div>

                <div class="mb-2 col-span-1">
                    <label>Bonus 1:</label>
                    <input type="number" name="m_b1" id="m_b1" class="w-full border px-3 py-1">
                </div>

                <div class="mb-2 col-span-1">
                    <label>Bonus 2:</label>
                    <input type="number" name="m_b2" id="m_b2" class="w-full border px-3 py-1">
                </div>

                <div class="mb-2 col-span-1">
                    <label>Bonus 3:</label>
                    <input type="number" name="m_b3" id="m_b3" class="w-full border px-3 py-1">
                </div>

                <div class="mb-2 col-span-1">
                    <label>Bonus 4:</label>
                    <input type="number" name="m_b4" id="m_b4" class="w-full border px-3 py-1">
                </div>

                <div class="mb-2 col-span-1">
                    <label>Bonus 5:</label>
                    <input type="number" name="m_b5" id="m_b5" class="w-full border px-3 py-1">
                </div>

                <div class="col-span-3 flex justify-end mt-4">
                    <button type="button" onclick="closeModalRow()"
                        class="bg-gray-300 px-4 py-1 rounded mr-2">Cancel</button>
                    <button type="submit" class="bg-blue-600 text-white px-4 py-1 rounded">Save</button>
                </div>
            </form>
        </div>
    </div>

    <script>
        function closeModalRow() {
            document.getElementById('updateSalaryRow').classList.add('hidden');
        }

        function openModalRow(data) {
            document.getElementById('m_FullName').value = data.full_name;
            document.getElementById('m_HeadCode').value = data.head_code;
            document.getElementById('m_RegNo').value = data.registration_no;
            document.getElementById('m_Salary').value = data.salary;
            document.getElementById('m_b1').value = data.b1;
            document.getElementById('m_b2').value = data.b2;
            document.getElementById('m_b3').value = data.b3;
            document.getElementById('m_b4').value = data.b4;
            document.getElementById('m_b5').value = data.b5;

            document.getElementById('updateSalaryRow').classList.remove('hidden');
        }

        function updateSalaryRow(button) {
            const row = button.closest('tr');

            const staff_id = row.getAttribute('data-id');
            const headCode = row.getAttribute('data-head_code');
            const regNo = row.getAttribute('data-reg_no');
            const fullName = row.querySelector('td:nth-child(1)').innerText.trim();
            const salary = row.querySelector('td:nth-child(9)').innerText.trim();
            const b1 = row.querySelector('td:nth-child(3)').innerText.trim();
            // Get b2 to b5 similarly if needed

            openModalRow({
                staff_id,
                full_name: fullName,
                head_code: headCode,
                registration_no: regNo,
                salary,
                b1,
                b2: row.querySelector('td:nth-child(4)').innerText.trim(),
                b3: row.querySelector('td:nth-child(5)').innerText.trim(),
                b4: row.querySelector('td:nth-child(6)').innerText.trim(),
                b5: row.querySelector('td:nth-child(7)').innerText.trim(),
            });
        }

        function toggleDropdown(btn) {
            const dropdown = btn.nextElementSibling;
            dropdown.classList.toggle('hidden');
        }
    </script>

    <script>
        $('#staff-search').on('change', function() {
            let selectedStaff = $(this).val(); // Get the selected staff value

            // Only trigger the AJAX call if a valid staff member is selected
            if (selectedStaff) {
                $.ajax({
                    url: "{{ route('staff.salary') }}", // Ensure this route is correct
                    type: "GET",
                    data: {
                        search: selectedStaff // Send the selected staff value in the AJAX request
                    },
                    success: function(data) {

                        $('#staff-table').html(data); // Update the staff table with the new data
                    },
                    error: function(xhr, status, error) {
                        console.error('AJAX error:', error); // Debug: Log any errors
                        alert('Something went wrong. Please try again.');
                    }
                });
            }
        });

        function toggleDropdown(button) {
            // Close all dropdowns first
            document.querySelectorAll(".action-dropdown").forEach((dropdown) => {
                if (dropdown !== button.nextElementSibling) {
                    dropdown.classList.add("hidden");
                }
            });

            // Toggle the clicked dropdown
            const dropdown = button.nextElementSibling;
            dropdown.classList.toggle("hidden");
        }

        // Close dropdown when clicking outside
        document.addEventListener("click", function(event) {
            if (!event.target.closest(".action-btn")) {
                document.querySelectorAll(".action-dropdown").forEach((dropdown) => {
                    dropdown.classList.add("hidden");
                });
            }
        });
    </script>
@endsection
