<!DOCTYPE html>
<html>
<head>
    <title>Salary Generate Report PDF</title>
    <style>
        body { font-family: sans-serif; font-size: 11px; }
        table { width: 100%; border-collapse: collapse; }
        th, td { border: 1px solid #ccc; padding: 6px; text-align: center; }
        th { background: #f5f5f5; }
    </style>
</head>
<body>
    <h3>Salary Report - {{ $month ?? 'All Months' }} / {{ $year ?? 'All Years' }}</h3>

    <table>
        <thead>
            <tr>
                <th>Staff</th>
                <th>Reg No</th>
                <th>Status</th>
                <th>Date</th>
                <th>Month</th>
                <th>Year</th>
                <th>B1</th>
                <th>B2</th>
                <th>B3</th>
                <th>B4</th>
                <th>B5</th>
                <th>Total B</th>
                <th>Salary</th>
                <th>Net Salary</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($staffs as $f)
                <tr>
                    <td>{{ $f->staff_member->full_name ?? 'N/A' }}</td>
                    <td>{{ $f->reg_no ?? 'N/A' }}</td>
                    <td>{{ $f->staff_member->status ?? 'N/A' }}</td>
                    <td>{{ $f->generate_salary->date ?? 'N/A' }}</td>
                    <td>{{ $f->generate_salary->month ?? 'N/A' }}</td>
                    <td>{{ $f->generate_salary->year ?? 'N/A' }}</td>
                    <td>{{ $f->b1 ?? 0 }}</td>
                    <td>{{ $f->b2 ?? 0 }}</td>
                    <td>{{ $f->b3 ?? 0 }}</td>
                    <td>{{ $f->b4 ?? 0 }}</td>
                    <td>{{ $f->b5 ?? 0 }}</td>
                    <td>{{ ($f->b1 ?? 0) + ($f->b2 ?? 0) + ($f->b3 ?? 0) + ($f->b4 ?? 0) + ($f->b5 ?? 0) }}</td>
                    <td>{{ $f->salary ?? 0 }}</td>
                    <td>{{ ($f->salary ?? 0) + ($f->b1 ?? 0) + ($f->b2 ?? 0) + ($f->b3 ?? 0) + ($f->b4 ?? 0) + ($f->b5 ?? 0) }}</td>
                </tr>
            @endforeach
        </tbody>
    </table>
</body>
</html>
