@extends('schoolLayout.app')
@section('content')
    <style>
        .custom-select2+.select2-container .select2-selection--single {
            height: 38px !important;
            display: flex;
            align-items: center;
            border-radius: 0.375rem;
            border: 1px solid #d1d5db;
            padding-left: 0.75rem;
            padding-right: 0.75rem;
        }

        .custom-select2+.select2-container .select2-selection__rendered {
            font-size: 16px;
            line-height: 48px;
        }
    </style>
@include('successError')
    <div class="flex justify-between items-center  pb-4">
        @include('salary.partialHead')
    </div>
    <div class="border border-gray-200 rounded-lg">
        <!-- Search and Filters -->
        <div class="py-4 flex rounded-lg items-center overflow-hidden bg-white px-4 gap-4">
           {{--  <form class="flex" method="GET">
                @csrf
                <div class="p-3 m-3">
                    <label for="all">All</label>
                    <input type="checkbox" name="all" id="filter_all">
                </div>
                @if ($roles)
                    @foreach ($roles as $role)
                        <div class="p-3 m-3">
                            <label for="{{ $role->title }}">{{ $role->title }}</label>
                            <input type="checkbox" name="{{ $role->title }}" id="" class="roles_select"
                                @if (in_array($role->title, $input)) checked @endif>
                        </div>
                    @endforeach
                @endif

                <button type="submit" class="px-4 py-2  bg-[#0197FF] text-white rounded hover:bg-blue-700">Search</button>
            </form> --}}
        </div>
        <div class=" rounded-lg relative">
            <table class="w-full border-collapse">
                <thead>
                    <tr class="text-gray-600">
                        <th class="p-3 text-left font-medium">Employee Name</th>
                        <th class="p-3 text-left font-medium">Role</th>
                        <th class="p-3 text-left font-medium">Bonus</th>
                        <th class="p-3 text-left font-medium">Salary</th>
                        <th class="p-3 text-left font-medium">Pay amount</th>
                        <th class="p-3 text-center font-medium">Select to pay <br><input type="checkbox"
                                class="select-checkbox" id="select_all">
                        </th>
                    </tr>
                </thead>
                <form action="{{ route('salary.pay.store') }}" method="POST">
                    @csrf
                    <tbody class="bg-white">
                        <tr class="border-b">
                            <td class="p-3 items-end" colspan="3">
                            </td>
                            <td class="p-3 items-end" >
                                Date
                            </td>
                            <td class="p-3  items-center">
                                <input type="date" name="date" id="date" required>
                            </td>
                        </tr>
                        @foreach ($stafflists as $staff)
                        @php
                            $totalBonus = ($staff->SalaryStruct->b1 ?? 0)
                                        + ($staff->SalaryStruct->b2 ?? 0)
                                        + ($staff->SalaryStruct->b3 ?? 0)
                                        + ($staff->SalaryStruct->b4 ?? 0)
                                        + ($staff->SalaryStruct->b5 ?? 0);
                        @endphp
                    
                        <tr class="border-b">
                            <td class="p-3 flex items-center">
                                <img src="{{ asset('assets/sidebar/student.png') }}" alt="Student"
                                    class="w-10 h-10 rounded-full" />
                                <div class="ml-3">
                                    <p class="font-medium">{{ $staff->full_name }} - {{ $staff->registration_no }}</p>
                                    <p class="text-gray-600">{{ $staff->email }}</p>
                                </div>
                            </td>
                            <td class="p-3 text-gray-500">Teacher</td>
                            <td class="p-3 text-gray-500">
                                 {{ $totalBonus }}
                            </td>
                            <td class="p-3 text-gray-500">
                                {{ $staff->salary }}
                            </td>
                            <td class="p-3">
                                <input type="number" name="pay_amount[{{ $staff->head_code }}]"
                                       id="pay_amount_{{ $staff->head_code }}"
                                       class="w-50 border rounded px-2 py-1 focus:outline-none"
                                       placeholder="0"
                                       value="{{ $staff->salary + $totalBonus }}" />
                            </td>
                            <td class="p-3 text-center relative">
                                <input type="checkbox" class="select-checkbox" id="select_{{ $staff->head_code }}"
                                       name="select[{{ $staff->head_code }}]" value="{{ $staff->head_code }}" />
                            </td>
                        </tr>
                    @endforeach
                        <tr class="mt-4 text-right">
                            <td class="font-bold text-gray-700" colspan="4">Total Selected Pay Amount:</td>
                            <td id="total_pay" name="total_pay" class="text-blue-600 font-bold">0.00</td>
                            <input type="hidden" name="total_pay_input" id="total_pay_input" value="0">

                        </tr>

                    </tbody>
                    <tfoot class="bg-white">
                        <tr class="border-t">
                            <td class="p-3 text-right font-medium"></td>
                            <td class="p-3 text-right font-medium"></td>
                            <td class="p-3 text-right font-medium"></td>
                            <td class="p-3 text-right font-medium"></td>
                            <td class="p-3 text-right font-medium"></td>
                            <td class="p-3 text-center font-medium">
                                <button type="submit" id="pay_button" name="pay_button"
                                    class="px-4 py-2 bg-[#0197FF] text-white rounded hover:bg-blue-700">Pay</button>
                            </td>
                        </tr>
                    </tfoot>
                </form>
            </table>
        </div>
    </div>
  @include('salary.component', ['staffs' => $stafflists])

    <script>
    document.addEventListener('DOMContentLoaded', function() {
        const checkboxes = document.querySelectorAll('.select-checkbox');
        const payButton = document.getElementById('pay_button'); // Pay button id
        const totalPayDisplay = document.getElementById('total_pay');
        const totalPayInput = document.getElementById('total_pay_input');

        function calculateTotal() {
            let total = 0;

            checkboxes.forEach(checkbox => {
                if (checkbox.checked) {
                    const headCode = checkbox.value;
                    const amountInput = document.querySelector(`input[name="pay_amount[${headCode}]"]`);
                    const value = parseFloat(amountInput?.value) || 0;
                    total += value;
                }
            });

            totalPayDisplay.innerText = total.toFixed(2);
            totalPayInput.value = total.toFixed(2);

            // Disable or Enable Pay Button
            if (total <= 0) {
                payButton.disabled = true;
            } else {
                payButton.disabled = false;
            }
        }

        // Attach event listeners
        checkboxes.forEach(cb => cb.addEventListener('change', calculateTotal));
        document.querySelectorAll('input[name^="pay_amount"]').forEach(input => {
            input.addEventListener('input', calculateTotal);
        });

        // Initial run
        calculateTotal();
    });
</script>


@endsection
