@extends('schoolLayout.app')
@section('content')
    <style>
        /* Increase height of the Select2 container */
        .custom-select2+.select2-container .select2-selection--single {
            height: 38px !important;
            display: flex;
            align-items: center;
            border-radius: 0.375rem;
            border: 1px solid #d1d5db;
            padding-left: 0.75rem;
            padding-right: 0.75rem;
        }

        /* Optional: increase font size */
        .custom-select2+.select2-container .select2-selection__rendered {
            font-size: 16px;
            line-height: 48px;
        }
    </style>

    @include('successError')
    <div class="flex justify-between items-center  pb-4">
        @include('salary.partialHead')
    </div>
    <div class="flex items-center mt-4 space-x-4">

        <select id="staff-search" name="staff-search" class=" select2 custom-select2 border p-2 rounded-lg  ">
            <option value="">Select Staff</option>
            @foreach ($staffList as $s)
                <option value="{{ $s->head_code }}">
                    {{ $s->full_name }} - {{ $s->registration_no }}
                </option>
            @endforeach
        </select>
        <form action="{{ route('pdf.salary.generate.report') }}" method="GET" class="flex items-center gap-2 mt-4">
            <select name="month" class="border px-2 py-1 rounded">
                <option value="all">All Months</option>
                <option value="january">January</option>
                <option value="february">February</option>
                <option value="march">March</option>
                <option value="april">April</option>
                <option value="may">May</option>
                <option value="june">June</option>
                <option value="july">July</option>
                <option value="august">August</option>
                <option value="september">September</option>
                <option value="october">October</option>
                <option value="november">November</option>
                <option value="december">December</option>
            </select>


            <select name="year" class="border px-2 py-1 rounded">
                <option value="">All Years</option>
                @for ($y = now()->year; $y >= 2020; $y--)
                    <option value="{{ $y }}">{{ $y }}</option>
                @endfor
            </select>

            <button type="submit" class="bg-[#0197FF] text-white px-4 py-2 rounded hover:bg-blue-600">
                PDF
            </button>
        </form>

    </div>
    <!-- Applications Table -->
    <div class="bg-white py-3 rounded-lg shadow mt-6 relative">
        <!-- 🔁 Container for results -->
        <div id="staff-table" class="bg-white py-3 rounded-lg shadow mt-6 relative">
            @include('salary.partialGenReport', ['staffs' => $staffs])
        </div>
    </div>
    <div class="flex justify-between items-center px-4 pt-4 border-t border-gray-200 mt-8">
        <div class="flex items-center text-sm text-gray-500">
            Showing {{ $staffs->firstItem() }} to {{ $staffs->lastItem() }} of {{ $staffs->total() }} results

            <form method="GET" class="ml-3">
                <select name="entries" onchange="this.form.submit()"
                    class="border rounded-lg px-1 py-1 text-sm focus:outline-none focus:ring-2 focus:ring-blue-400">
                    <option value="40" {{ request('entries') == 40 ? 'selected' : '' }}>40</option>
                    <option value="80" {{ request('entries') == 80 ? 'selected' : '' }}>80</option>
                    <option value="120" {{ request('entries') == 120 ? 'selected' : '' }}>120</option>
                </select>
            </form>
        </div>

        <div class="mt-2">
            {{ $staffs->appends(request()->query())->onEachSide(1)->links('pagination::tailwind') }}

        </div>
    </div>

    @include('salary.component', ['staffs' => $staffList])

    <script>
        $(document).on('click', '.pagination a', function(event) {
            event.preventDefault();
            let url = $(this).attr('href');

            $.ajax({
                url: url,
                type: "GET",
                success: function(data) {
                    $('#staff-table').html(data);
                }
            });
        });
    </script>

    <script>
        $('#staff-search').on('change', function() {
            let selectedStaff = $(this).val();

            if (selectedStaff) {
                $.ajax({
                    url: "{{ route('staff.gen.indexR') }}",
                    type: "GET",
                    data: {
                        search: selectedStaff
                    },
                    success: function(data) {
                        $('#staff-table').html(data);
                    }
                });
            }
        });


        function toggleDropdown(button) {
            // Close all dropdowns first
            document.querySelectorAll(".action-dropdown").forEach((dropdown) => {
                if (dropdown !== button.nextElementSibling) {
                    dropdown.classList.add("hidden");
                }
            });

            // Toggle the clicked dropdown
            const dropdown = button.nextElementSibling;
            dropdown.classList.toggle("hidden");
        }

        // Close dropdown when clicking outside
        document.addEventListener("click", function(event) {
            if (!event.target.closest(".action-btn")) {
                document.querySelectorAll(".action-dropdown").forEach((dropdown) => {
                    dropdown.classList.add("hidden");
                });
            }
        });
    </script>
@endsection
