   <!-- Modal -->
   <div id="salaryModal" class="fixed inset-0 mt-10 flex items-center justify-center bg-black bg-opacity-50 hidden">
       <div class="bg-white w-[60%] rounded-lg shadow-lg max-h-[80vh] overflow-auto">
           <!-- Modal Header -->
           <div class="flex items-center px-4 py-5 border-b border-gray-200 justify-between">
               <h2 class="text-xl">Generate Salary</h2>
               <button id="closeModal" class="text-gray-600 hover:text-gray-900">
                   <i class="fa-solid fa-xmark"></i>
               </button>
           </div>

           <div class="px-5 py-3">
               <form method="POST" id="GSform" name="GSform" action="{{ route('salary.gn.store') }}"
                   class="space-y-3">
                   @csrf
                   <!-- Radio Buttons -->
                   <div class="flex items-center mb-3 space-x-4">
                       <label class="flex items-center space-x-2">
                           <input type="radio" name="salaryType" id="type_all" value="all"
                               class="form-radio text-blue-600" checked/>
                           <span>All Staff</span>
                       </label>
                       <label class="flex items-center space-x-2">
                           <input type="radio" name="salaryType" id="type_single" value="single"
                               class="form-radio text-blue-600"  />
                           <span>Single Staff</span>
                       </label>

                   </div>

                   <div>
                       <label class="block  mt-2 text-[#374151] font-medium mb-1">Month</label>
                       <select id="month_gn" name="month_gn"
                           class="select2 custom-select2 w-full border rounded px-3 py-2 focus:outline-none" required>
                           <option value="">Select month</option>
                           @foreach (['January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December'] as $month)
                               <option value="{{ $month }}">{{ $month }}</option>
                           @endforeach
                       </select>
                   </div>
                   <!-- Fields to Hide for All Staff -->
                   <div id="singleFields">
                       <div>
                           <label class="block  text-[#374151] font-medium mb-1">Employee Name</label>

                           <select class="select2 custom-select2 w-full border rounded px-3 py-2" id="emp_name_gn"
                               name="head_code_gn" required>
                               <option value="">Select Staff Member</option>
                               @foreach ($staffs as $s)
                                   <option value="{{ $s->head_code }}">{{ $s->full_name }} - {{ $s->registration_no }}
                                   </option>
                               @endforeach
                           </select>
                       </div>

                       <div>
                           <label class="block mt-2 text-[#374151] font-medium mb-1">CNIC</label>
                           <input type="text" id="cnic_gn" name="cnic_gn"
                               class="w-full border rounded px-3 py-2 focus:outline-none" readonly />
                       </div>

                       <div>
                           <label class="block  mt-2 text-[#374151] font-medium mb-1">Reg No</label>
                           <input type="text" id="reg_no_gn" name="reg_no_gn"
                               class="w-full border rounded px-3 py-2 focus:outline-none" readonly />
                       </div>

                       <div>
                           <label class="block  mt-2 text-[#374151] font-medium mb-1">Salary</label>
                           <input type="number" id="salary_gn" name="salary_gn" placeholder="0"
                               class="w-full border rounded px-3 py-2 focus:outline-none" />
                       </div>
                       <div>
                           <label class="block  mt-2 text-[#374151] font-medium mb-1">Bonus 1</label>
                           <input type="number" id="b1_gn" name="b1_gn" placeholder="0"
                               class="w-full border rounded px-3 py-2 focus:outline-none" />
                       </div>
                       <div>
                           <label class="block  mt-2 text-[#374151] font-medium mb-1">Bonus 2</label>
                           <input type="number" id="b2_gn" name="b2_gn" placeholder="0"
                               class="w-full border rounded px-3 py-2 focus:outline-none" />
                       </div>
                       <div>
                           <label class="block  mt-2 text-[#374151] font-medium mb-1">Bonus 3</label>
                           <input type="number" id="b3_gn" name="b3_gn" placeholder="0"
                               class="w-full border rounded px-3 py-2 focus:outline-none" />
                       </div>
                       <div>
                           <label class="block  mt-2 text-[#374151] font-medium mb-1">Bonus 4</label>
                           <input type="number" id="b4_gn" name="b4_gn" placeholder="0"
                               class="w-full border rounded px-3 py-2 focus:outline-none" />
                       </div>
                       <div>
                           <label class="block  mt-2 text-[#374151] font-medium mb-1">Bonus 5</label>
                           <input type="number" id="b5_gn" name="b5_gn" placeholder="0"
                               class="w-full border rounded px-3 py-2 focus:outline-none" />
                       </div>
                   </div>

                   <div>
                       <label class="block  mt-4 text-[#374151] font-medium mb-1">Date</label>
                       <input type="date" id="date_gn" name="date_gn"
                           class="w-full border rounded px-3 py-2 focus:outline-none" required />
                   </div>
                   <!-- Modal Footer -->
                   <div class="flex justify-end mt-4 border-t border-gray-200 bg-[#f9fafc] px-6 py-3 space-x-3">
                       <button id="closeModalBtn" type="button"
                           class="px-4 py-2 border border-gray-400 text-gray-800 rounded">
                           Cancel
                       </button>
                       <button type="submit" class="px-4 py-2 bg-[#0197FF] text-white rounded hover:bg-blue-700">
                           Submit
                       </button>
                   </div>
               </form>
           </div>
       </div>
   </div>

   <!--Salary Structure Modal -->
   <div id="salaryModalStruct"
       class="fixed inset-0 mt-10 flex items-center justify-center bg-black bg-opacity-50 hidden">
       <div class="bg-white w-[60%]  rounded-lg shadow-lg max-h-[80vh] overflow-auto">
           <!-- Modal Header -->
           <div class="flex items-center px-4 py-5 border-b border-gray-200 justify-between">
               <h2 class="text-xl">Update Salary</h2>
               <button id="closeModalStruct" class="text-gray-600 hover:text-gray-900">
                   <i class="fa-solid fa-xmark"></i>
               </button>
           </div>
           <div class="px-5 py-3">
               <form class="space-y-3" id="salaryStructForm" method="POST"
                   action="{{ route('salary.struct.update') }}">
                   @csrf
                   <div>
                       <label class="block text-[#374151] font-medium mb-1">Employee Name</label>
                       <select class="select2 custom-select2 w-full border rounded px-3 py-2" id="emp_name_st"
                           name="emp_name_st">
                           <option value="">Select</option>
                           @foreach ($staffs as $s)
                               <option value="{{ $s->head_code }}">{{ $s->full_name }} - {{ $s->registration_no }}
                               </option>
                           @endforeach
                       </select>
                   </div>
                   <div>
                       <label class="block text-[#374151] font-medium mb-1">CNIC</label>
                       <input type="text" class="w-full border bg-gray-100 rounded px-3 py-2 focus:outline-none"
                           id="cnic_st" name="cnic_st" disabled />
                   </div>
                   <div>
                       <label class="block text-[#374151] font-medium mb-1">Reg no</label>
                       <input type="text" class="w-full border bg-gray-100 rounded px-3 py-2 focus:outline-none"
                           id="reg_no_st" name="reg_no" readonly />
                   </div>

                   <div>
                       <label class="block text-[#374151] font-medium mb-1">Salary</label>
                       <input type="number" placeholder="0.0"
                           class="w-full border rounded px-3 py-2 focus:outline-none" id="salary_st" name="salary"
                           required />
                   </div>
                   <div>
                       <label class="block text-[#374151] font-medium mb-1">bonus 1</label>
                       <input type="number" placeholder="0.0"
                           class="w-full border rounded px-3 py-2 focus:outline-none" id="b1_st"
                           name="b1" />
                   </div>
                   <div>
                       <label class="block text-[#374151] font-medium mb-1">bonus 2</label>
                       <input type="number" placeholder="0.0"
                           class="w-full border rounded px-3 py-2 focus:outline-none" id="b2_st"
                           name="b2" />
                   </div>
                   <div>
                       <label class="block text-[#374151] font-medium mb-1">bonus 3</label>
                       <input type="number" placeholder="0.0"
                           class="w-full border rounded px-3 py-2 focus:outline-none" id="b3_st"
                           name="b3" />
                   </div>
                   <div>
                       <label class="block text-[#374151] font-medium mb-1">bonus 4</label>
                       <input type="number" placeholder="0.0"
                           class="w-full border rounded px-3 py-2 focus:outline-none" id="b4_st"
                           name="b4" />
                   </div>
                   <div>
                       <label class="block text-[#374151] font-medium mb-1">bonus 5</label>
                       <input type="number" placeholder="0.0"
                           class="w-full border rounded px-3 py-2 focus:outline-none" id="b5_st"
                           name="b5" />
                   </div>
               </form>
           </div>
           <!-- Modal Footer -->
           <div class="flex justify-end mt-4 border-t border-gray-200 bg-[#f9fafc] px-6 py-3 space-x-3">
               <button id="closeModalBtnStruct" type="button"
                   class="px-4 py-2 border border-gray-400 text-gray-800 rounded">
                   Cancel
               </button>
               <button type="button" onclick="updateSalaryStructure();"
                   class="px-4 py-2 bg-[#0197FF] text-white rounded hover:bg-blue-700">
                   Save
               </button>
           </div>
       </div>
   </div>
   <style>
       .error {
           color: red;
           /* Make error messages red */
           font-size: 16px;
           /* Optional: change the font size */
           margin-top: 5px;
           /* Optional: adjust the margin */
       }
   </style>
   <script>
       $(document).ready(function() {
           const validator = $('#salaryStructForm').validate({
               rules: {
                   emp_name_st: {
                       required: true
                   },
                   salary_st: {
                       required: true,
                       number: true,
                       min: 1
                   }
               },
               messages: {
                   emp_name_st: {
                       required: "Please select an employee."
                   },
                   salary_st: {
                       required: "Please enter salary.",
                       number: "Salary must be a valid number.",
                       min: "Salary must be greater than 0."
                   }
               },
               errorClass: 'text-red-500 mt-1',
               errorPlacement: function(error, element) {
                   if (element.hasClass("select2-hidden-accessible")) {
                       error.insertAfter(element.next('.select2'));
                   } else {
                       error.insertAfter(element);
                   }
               }
           });

           // Save button click
           window.updateSalaryStructure = function() {
               if ($('#salaryStructForm').valid()) {
                   $('#salaryStructForm').submit();
               }
           };
       });
   </script>


   <script>
       $(document).ready(function() {
           function setupValidation() {
               // Remove any previous rules
               $('#month_gn, #date, #emp_name_gn, #salary_gn').rules('remove');

               var type = $('#type').val();

               // Always required
               $('#month_gn').rules('add', {
                   required: true,
                   messages: {
                       required: "Please select a month."
                   }
               });

               $('#date').rules('add', {
                   required: true,
                   messages: {
                       required: "Please select a date."
                   }
               });

               if (type === 'single') {
                   $('#emp_name_gn').rules('add', {
                       required: true,
                       messages: {
                           required: "Please select a staff member."
                       }
                   });

                   $('#salary_gn').rules('add', {
                       required: true,
                       number: true,
                       min: 1,
                       messages: {
                           required: "Please enter salary.",
                           number: "Salary must be a number.",
                           min: "Salary must be greater than 0."
                       }
                   });
               }
           }

           // Run validation setup on type change
           $('#type').change(function() {
               setupValidation();
               $('#GSform').valid(); // Trigger revalidation
           });

           // Setup form validation
           $('#GSform').validate({
               errorClass: 'error', // Specify the error class for styling
               submitHandler: function(form) {
                   form.submit();
               }
           });
           setupValidation();
       });
   </script>

   <script>
       document.addEventListener('DOMContentLoaded', function() {
           const radios = document.querySelectorAll('input[name="salaryType"]');
           const singleFields = document.getElementById('singleFields');

           radios.forEach(radio => {
               radio.addEventListener('change', () => {
                   if (radio.value === 'all') {
                       singleFields.classList.add('hidden');
                   } else {
                       singleFields.classList.remove('hidden');
                   }
               });
           });
           document.querySelector('input[name="salaryType"]:checked').dispatchEvent(new Event('change'));
       });


       $(document).ready(function() {
           $('.select2').select2({
               allowClear: true,
               width: '100%' // Ensure full width
           });
       });
       // Focus on the search field when the Select2 dropdown opens
       $(document).on('select2:open', function() {
           const searchField = $('.select2-search__field');
           if (searchField.length) {
               searchField[0].focus();
           }
       });



       //------------------------------------------------------------//
       $(document).ready(function() {

           $('#emp_name_st').on('change', function() {
               const headCode = $(this).val();
               if (!headCode) return;
               fetch(`/salary/struct/${headCode}`)
                   .then(response => response.json())
                   .then(data => {
                       $('#cnic_st').val(data.cnic || '');
                       $('#reg_no_st').val(data.reg_no || '');
                       $('#salary_st').val(data.salary || '');
                       $('#b1_st').val(data.b1 || '');
                       $('#b2_st').val(data.b2 || '');
                       $('#b3_st').val(data.b3 || '');
                       $('#b4_st').val(data.b4 || '');
                       $('#b5_st').val(data.b5 || '');
                   })
                   .catch(error => {
                       console.error('Error fetching salary structure:', error);
                   });
           });

           $('#emp_name_gn').on('change', function() {
               const headCode = $(this).val();
               if (!headCode) return;

               fetch(`/salary/single/${headCode}`)
                   .then(response => response.json())
                   .then(data => {
                       $('#cnic_gn').val(data.cnic_gn || '');
                       $('#reg_no_gn').val(data.reg_no_gn || '');
                       $('#salary_gn').val(data.salary_gn || '');
                       $('#b1_gn').val(data.b1_gn || '');
                       $('#b2_gn').val(data.b2_gn || '');
                       $('#b3_gn').val(data.b3_gn || '');
                       $('#b4_gn').val(data.b4_gn || '');
                       $('#b5_gn').val(data.b5_gn || '');
                   })
                   .catch(error => {
                       console.error('Error fetching salary data:', error);
                   });
           });
       });


       //-----------------------------------------------------//
       function openModal() {
           document.getElementById("salaryModal").classList.remove("hidden");
       }

       function closeModal() {
           document.getElementById("salaryModal").classList.add("hidden");
       }

       document
           .getElementById("closeModal")
           .addEventListener("click", closeModal);
       document
           .getElementById("closeModalBtn")
           .addEventListener("click", closeModal);
       //-------------------------------------------------------//
       function openModalStruct() {
           document.getElementById("salaryModalStruct").classList.remove("hidden");
       }

       function closeModalStruct() {
           document.getElementById("salaryModalStruct").classList.add("hidden");
       }

       document
           .getElementById("closeModalStruct")
           .addEventListener("click", closeModalStruct);
       document
           .getElementById("closeModalBtnStruct")
           .addEventListener("click", closeModalStruct);

       //----------------------------------------------------//
       function toggleDropdown(button) {
           // Close any open dropdowns
           document.querySelectorAll(".action-dropdown").forEach((dropdown) => {
               if (dropdown !== button.nextElementSibling) {
                   dropdown.classList.add("hidden");
               }
           });

           // Toggle the clicked dropdown
           const dropdown = button.nextElementSibling;
           dropdown.classList.toggle("hidden");
       }

       // Close dropdown when clicking outside
       document.addEventListener("click", function(event) {
           if (!event.target.closest(".action-btn")) {
               document.querySelectorAll(".action-dropdown").forEach((dropdown) => {
                   dropdown.classList.add("hidden");
               });
           }
       });

       function updateSalaryStructure() {
           document.querySelector('#salaryStructForm').submit();
       }
       document.getElementById('select_all').addEventListener('change', function() {
           const checkboxes = document.querySelectorAll('.select-checkbox');
           checkboxes.forEach(checkbox => {
               checkbox.checked = this.checked;
           });
       });

       // Select all checkboxes by default when the page loads
       document.addEventListener('DOMContentLoaded', function() {
           const selectAllCheckbox = document.getElementById('select_all');
           selectAllCheckbox.checked = true;
           const checkboxes = document.querySelectorAll('.select-checkbox');
           checkboxes.forEach(checkbox => {
               checkbox.checked = true;
           });
       });

       document.querySelectorAll('.select-checkbox').forEach(checkbox => {
           checkbox.addEventListener('change', function() {
               if (!this.checked) {
                   document.getElementById('select_all').checked = false;
               }
           });
       });
   </script>
