<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>School Dashboard Report</title>
    <style>
        body {
            font-family: DejaVu Sans, sans-serif;
            font-size: 13px;
            color: #333;
            padding: 30px;
        }

        h1, h2 {
            text-align: center;
            color: #2c3e50;
            margin-bottom: 10px;
        }

        .section {
            margin-bottom: 35px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 15px;
        }

        th {
            background-color: #f4f6f8;
            padding: 10px;
            border: 1px solid #dee2e6;
            text-align: left;
            font-weight: 600;
        }

        td {
            padding: 9px;
            border: 1px solid #dee2e6;
            text-align: left;
        }

        .highlight {
            font-weight: bold;
            color: #1d3557;
        }

        .financial {
            width: 60%;
            margin: auto;
        }

        .text-center {
            text-align: center;
        }

        .title-bar {
            font-size: 18px;
            font-weight: bold;
            color: #1a202c;
            border-bottom: 2px solid #ccc;
            padding-bottom: 4px;
            margin-bottom: 8px;
        }

        .value {
            color: #2e86de;
            font-weight: bold;
        }
    </style>
</head>
<body>

    <h1> XXXSchool</h1>
    <h2>Dashboard Summary Report</h2>

    <!-- Student Application Summary -->
    <div class="section">
        <div class="title-bar">Student Applications</div>
        <table>
            <tr><th>Accepted</th><td class="value">{{ $accept }}</td></tr>
            <tr><th>Pending</th><td class="value">{{ $pending }}</td></tr>
            <tr><th>Rejected</th><td class="value">{{ $reject }}</td></tr>
        </table>
    </div>

    <!-- Students Overview -->
    <div class="section">
        <div class="title-bar">Students Overview</div>
        <table>
            <tr><th>Active Students</th><td class="value">{{ $totalStudents }}</td></tr>
            <tr><th>Alumni</th><td class="value">{{ $totalAlumni }}</td></tr>
        </table>
    </div>

    <!-- Financial Summary -->
    <div class="section">
        <div class="title-bar">Financial Summary</div>
        <table class="financial">
            <tr><th>Cash in Hand</th><td class="value">{{ number_format($cashInHandBalance, 2) }}</td></tr>
            <tr><th>Student Dues</th><td class="value">{{ number_format($studentDue, 2) }}</td></tr>
            <tr><th>Payable</th><td class="value">{{ number_format($payable, 2) }}</td></tr>
            <tr><th>Total Expense</th><td class="value">{{ number_format($totalExpense, 2) }}</td></tr>
            <tr><th>Salary Expense</th><td class="value">{{ number_format($totalSalaryExpense, 2) }}</td></tr>
            <tr><th>Other Income</th><td class="value">{{ number_format($totalOtherIncome, 2) }}</td></tr>
            <tr><th>Income from Students</th><td class="value">{{ number_format($incomeFromStd, 2) }}</td></tr>
        </table>
    </div>

    <!-- Students by Class -->
    <div class="section">
        <div class="title-bar">Active Students by Class</div>
        <table>
            <thead>
                <tr><th>Class</th><th>Active Count</th></tr>
            </thead>
            <tbody>
                @foreach ($stdCountClass as $class)
                    <tr>
                        <td>{{ $class->name }}</td>
                        <td class="value">{{ $class->active_count }}</td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>

    <!-- Staff Overview -->
    <div class="section">
        <div class="title-bar">Active Staff by Position</div>
        <table>
            <thead>
                <tr><th>Position</th><th>Active Count</th></tr>
            </thead>
            <tbody>
                @foreach ($positions as $position)
                    <tr>
                        <td>{{ ucfirst($position->title) }}</td>
                        <td class="value">{{ $position->active_count }}</td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>

    <p class="text-center" style="margin-top: 50px; font-size: 12px;">
        Generated on {{ \Carbon\Carbon::now()->format('d M Y, h:i A') }}
    </p>
</body>
</html>
