@extends('schoolLayout.app')
@section('content')
@include('successError')
<div class="mx-auto bg-white p-6 rounded-lg shadow-lg">
    <h2 class="text-2xl font-semibold text-gray-800 mb-4">Job Announcement Details</h2>

    <form id="jobPositionForm" action="{{ route('job-positions-store') }}" method="post">
        @csrf
        <!-- First Row -->
        <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-4">
            <div>
                <label class="block mb-1 text-gray-700 font-medium">Job Title<span class="text-red-600">*</span></label>
                <select name="title" id="title" class="w-full p-2 border rounded-md focus:ring-2 focus:ring-blue-500">
                    <option value="">Select Job Title</option>
                    <option value="teacher" {{ old('title') == 'teacher' ? 'selected' : '' }}>Teacher</option>
                    <option value="security guard" {{ old('title') == 'security guard' ? 'selected' : '' }}>Security Guard</option>
                    <option value="cook" {{ old('title') == 'cook' ? 'selected' : '' }}>Cook</option>
                </select>
                @error('title')
                    <span class="text-red-500 text-sm">{{ $message }}</span>
                @enderror
            </div>

            <div>
                <label class="block mb-1 text-gray-700 font-medium">Department/Subject Or Category<span class="text-red-600">*</span></label>
                <input type="text" name="category" id="category" placeholder="e.g. Science, Mathematics"
                    class="w-full p-2 border rounded-md focus:ring-2 focus:ring-blue-500"
                    value="{{ old('category') }}">
                @error('category')
                    <span class="text-red-500 text-sm">{{ $message }}</span>
                @enderror
            </div>
        </div>

        <!-- Second Row -->
        <div class="grid grid-cols-2 gap-4 mb-4">
            <div>
                <label class="block mb-1 text-gray-700 font-medium">Age Required<span class="text-red-600">*</span></label>
                <input type="number" name="age" id="age" placeholder="Minimum age"
                    class="w-full p-2 border rounded-md focus:ring-2 focus:ring-blue-500"
                    value="{{ old('age') }}">
                @error('age')
                    <span class="text-red-500 text-sm">{{ $message }}</span>
                @enderror
            </div>
            <div>
                <label class="block mb-1 text-gray-700 font-medium">Qualification Required<span class="text-red-600">*</span></label>
                <input name="qualification_required" id="qualification_required" type="text" placeholder="e.g. Bachelor's in Physics"
                    class="w-full p-2 border rounded-md focus:ring-2 focus:ring-blue-500"
                    value="{{ old('qualification_required') }}">
                @error('qualification_required')
                    <span class="text-red-500 text-sm">{{ $message }}</span>
                @enderror
            </div>
        </div>

        <!-- Third Row -->
        <div class="grid grid-cols-2 gap-4 mb-4">
            <div>
                <label class="block mb-1 text-gray-700 font-medium">Experience (Years)<span class="text-red-600">*</span></label>
                <input type="number" name="experience_required" id="experience_required" placeholder="2"
                    class="w-full p-2 border rounded-md focus:ring-2 focus:ring-blue-500"
                    value="{{ old('experience_required') }}">
                @error('experience_required')
                    <span class="text-red-500 text-sm">{{ $message }}</span>
                @enderror
            </div>
            <div>
                <label class="block mb-1 text-gray-700 font-medium">Salary<span class="text-red-600">*</span></label>
                <input name="salary" id="salary" type="text" placeholder="e.g. $50,000 - $70,000 per year"
                    class="w-full p-2 border rounded-md focus:ring-2 focus:ring-blue-500"
                    value="{{ old('salary') }}">
                @error('salary')
                    <span class="text-red-500 text-sm">{{ $message }}</span>
                @enderror
            </div>
        </div>

        <!-- Job Description -->
        <div class="mb-4">
            <label class="block mb-1 text-gray-700 font-medium">Job Description<span class="text-red-600">*</span></label>
            <textarea name="description" id="description" rows="4"
                placeholder="Enter detailed job description, responsibilities, and requirements"
                class="w-full p-2 border rounded-md focus:ring-2 focus:ring-blue-500">{{ old('description') }}</textarea>
            @error('description')
                <span class="text-red-500 text-sm">{{ $message }}</span>
            @enderror
        </div>

        <!-- Buttons -->
        <div class="flex justify-end gap-x-4">
            <button type="button" class="border px-2 rounded-md border-gray-400">Cancel</button>
            <button type="submit" class="bg-[#0197FF] text-white p-2 px-4 rounded-md hover:bg-blue-700 transition">
                Create Job Posting
            </button>
        </div>
    </form>
</div>
@endsection

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/jquery.validation/1.19.5/jquery.validate.min.js"></script>
<script>
$(document).ready(function () {
    $("#jobPositionForm").validate({
        rules: {
            title: { required: true },
            category: { required: true },
            age: { required: true, number: true, min: 18, max: 65 },
            qualification_required: { required: true },
            experience_required: { required: true, number: true, min: 0, max: 50 },
            salary: { required: true, number: true, min: 0 },
            description: { required: true, minlength: 10 }
        },
        messages: {
            title: "Please select a job title",
            category: "Please enter department/subject",
            age: {
                required: "Please enter minimum age",
                number: "Please enter a valid number",
                min: "Age must be at least 18",
                max: "Age must be at most 65"
            },
            qualification_required: "Please enter qualification required",
            experience_required: {
                required: "Please enter experience required",
                number: "Please enter a valid number",
                min: "Experience cannot be negative",
                max: "Experience cannot be more than 50 years"
            },
            salary: {
                required: "Please enter salary details",
                number: "Please enter a valid number",
                min: "Salary cannot be negative"
            },
            description: {
                required: "Please enter job description",
                minlength: "Description must be at least 10 characters"
            }
        },
        errorClass: "text-red-500 text-sm",
        errorElement: "span",
        highlight: function(element) {
            $(element).addClass('border-red-500');
        },
        unhighlight: function(element) {
            $(element).removeClass('border-red-500');
        }
    });
});
</script>
