<!DOCTYPE html>
<html>
<head>
    <title>All Job Positions</title>
    <style>
        body {
            font-family: DejaVu Sans, sans-serif;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            font-size: 12px;
        }

        th, td {
            border: 1px solid #333;
            padding: 6px;
            text-align: left;
        }

        th {
            background-color: #f0f0f0;
        }

        .status-open {
            color: green;
            font-weight: bold;
        }

        .status-closed {
            color: red;
            font-weight: bold;
        }
    </style>
</head>
<body>
    <h2>All Job Positions</h2>

    <table>
        <thead>
            <tr>
                <th>Title</th>
                <th>Category</th>
                <th>Qualifications</th>
                <th>Experience</th>
                <th>Description</th>
                <th>Salary</th>
                <th>Status</th>
                <th>Applications</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($allJob as $job)
                <tr>
                    <td>{{ ucfirst($job->title) }}</td>
                    <td>{{ $job->category }}</td>
                    <td>{{ $job->qualification_required }}</td>
                    <td>{{ $job->experience_required }}</td>
                    <td>{{ \Illuminate\Support\Str::limit($job->description, 50) }}</td>
                    <td>{{ $job->salary }}</td>
                    <td>
                        @if ($job->status == 'closed')
                            <span class="status-closed">Closed</span>
                        @else
                            <span class="status-open">Open</span>
                        @endif
                    </td>
                    <td>{{ $job->job_applications->count() }}</td>
                </tr>
            @endforeach
        </tbody>
    </table>
</body>
</html>
