<table class="w-full border-collapse">
    <thead class="border-y bg-[#f9fafc] border-gray-200">
        <tr class="text-gray-600 text-sm">
            <th class="p-3 text-left font-semibold">Title</th>
            <th class="p-3 text-left font-semibold">Job Category</th>
            <th class="p-3 text-left font-semibold">Qualifications</th>
            <th class="p-3 text-left font-semibold">Experience</th>
            <th class="p-3 text-left font-semibold">Description</th>
            <th class="p-3 text-left font-semibold">Salary</th>
            <th class="p-3 text-left font-semibold">Status</th>
            <th class="p-3 text-left font-semibold">Total Applications</th>
            <th class="p-3 text-center font-semibold">Actions</th>
        </tr>
    </thead>
    <tbody class="bg-white rounded-lg shadow">
        @if ($job_openings)
            @foreach ($job_openings as $job)
                <tr class="border-b hover:bg-blue-50 transition">
                    <td class="p-3 text-black font-semibold">
                        {{ Str::ucfirst($job->title) }}
                    </td>
                    <td class="p-3 text-gray-700">{{ $job->category }}</td>
                    <td class="p-3 text-gray-700">{{ $job->qualification_required }}</td>
                    <td class="p-3 text-gray-700">{{ $job->experience_required }}</td>
                    <td class="p-3 text-gray-700 truncate max-w-xs" title="{{ $job->description }}">
                        {{ Str::limit($job->description, 40) }}
                    </td>
                    <td class="p-3 text-gray-700">{{ $job->salary }}</td>
                    <td class="p-3">
                        @if ($job->status == 'closed')
                            <span
                                class="bg-red-100 text-red-700 font-semibold px-3 py-1 rounded-2xl text-xs">Closed</span>
                        @else
                            <span
                                class="bg-green-100 text-green-700 font-semibold px-3 py-1 rounded-2xl text-xs">Open</span>
                        @endif
                    </td>
                    <!-- Total Applications -->
                    <td class="p-3 text-center">
                        <span class="bg-blue-100 text-blue-700 px-3 py-1 rounded-2xl text-xs font-semibold">
                            {{ $job->job_applications->count() }}
                        </span>
                    </td>
                    <!-- Actions -->
                    <td class="p-3 flex justify-center items-center gap-x-3">
                        <button title="View Applications" class="hover:bg-green-50 p-2 rounded"
                            onclick="window.location.href ='{{ route('job_application', $job->id) }}'">
                            <i class="fa-solid fa-eye text-[#16A34A]"></i>
                        </button>
                        <button title="Edit" class="hover:bg-blue-50 p-2 rounded"
                            onclick="openEditModal({{ json_encode($job) }})">
                            <i class="fa-solid fa-pen-to-square text-[#2563EB]"></i>
                        </button>
                        {{-- <button title="Delete" class="hover:bg-red-50 p-2 rounded" onclick="deleteJob(this)" data-id="{{ $job->id }}">
                            <i class="fa-solid fa-trash text-red-500"></i>
                        </button> --}}
                    </td>
                </tr>
            @endforeach
        @endif
    </tbody>
</table>
