<div class="flex justify-between items-center mb-4">
    <div class="flex space-x-4 border-b border-gray-200 w-[50%]">
        <button
            class="tab-btn px-4 pb-3 py-2 font-semibold
                {{ Route::is('job_application') ? 'bg-white border-b-2 border-blue-500 text-blue-500' : 'text-gray-700' }}"
            onclick="window.location.href='{{ route('job_application') }}'">
            All App
        </button>
        <button
            class="tab-btn px-4 pb-3 py-2 font-semibold
                {{ Route::is('job.accepted.app') ? 'bg-white border-b-2 border-blue-500 text-blue-500' : 'text-gray-700' }}"
            onclick="window.location.href='{{ route('job.accepted.app') }}'">
            Accepted App
        </button>
        <button
            class="tab-btn px-4 pb-3 py-2 font-semibold
                {{ Route::is('job.rejected.app') ? 'bg-white border-b-2 border-blue-500 text-blue-500' : 'text-gray-700' }}"
            onclick="window.location.href='{{ route('job.rejected.app') }}'">
            Rejected App
        </button>
        <button
            class="tab-btn px-4 pb-3 py-2 font-semibold
                {{ Route::is('job.pending.app') ? 'bg-white border-b-2 border-blue-500 text-blue-500' : 'text-gray-700' }}"
            onclick="window.location.href='{{ route('job.pending.app') }}'">
            Pending App
        </button>
    </div>
    <!-- New Staff Member Button -->
    <button class="px-4 py-2 bg-[#0197FF] flex items-center gap-x-4 text-white rounded-lg"
        onclick="window.location.href = '{{ route('job_application_create') }}'">
        <img src="{{ asset('assets/new.png') }}" alt="icon" />
        <span>Apply For Job</span>
    </button>
</div>


<!-- Application Stats -->
<div class="flex py-4 w-full bg-white">
    <button
        class="tab-btn flex items-center gap-x-4 px-4 bg-white py-2 border-b-2 border-black font-semibold text-black">
        All
        <span class="bg-gray-200 px-4 py-1 font-bold text-gray-700 text-sm rounded-2xl">{{ $all }}</span>
    </button>
    <button class="tab-btn flex items-center gap-x-4 px-4 bg-white py-2 font-semibold text-gray-600">
        Pending
        <span class="bg-gray-200 px-4 py-1 text-gray-700 text-sm rounded-2xl">{{ $pending }}</span>
    </button>
    <button class="tab-btn flex items-center gap-x-4 px-4 bg-white py-2 font-semibold text-gray-600">
        Accepted
        <span class="bg-gray-200 px-4 py-1 text-green-700 text-sm rounded-2xl">{{ $accepted }}</span>
    </button>
    <button class="tab-btn flex items-center gap-x-4 px-4 bg-white py-2 font-semibold text-gray-600">
        Rejected
        <span class="bg-gray-200 px-4 py-1 text-red-700 text-sm rounded-2xl">{{ $rejected }}</span>
    </button>
</div>
