<!DOCTYPE html>
<html>
<head>
    <title>Income Report</title>
    <style>
        body { font-family: sans-serif; }
        table { width: 100%; border-collapse: collapse; font-size: 12px; }
        th, td { border: 1px solid #ddd; padding: 6px; text-align: left; }
        th { background: #f2f2f2; }
    </style>
</head>
<body>
    <h2>Income Report</h2>
    <table>
        <thead>
            <tr>
                <th>HeadCode</th>
                <th>Name</th>
                <th>Date</th>
                <th>Amount</th>
                <th>Description</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($incomeDetails as $income)
                <tr>
                    <td>{{ $income->income_account_id ?? 'N/A' }}</td>
                    <td>{{ $income->income_category->name ?? 'N/A' }}</td>
                    <td>{{ \Carbon\Carbon::parse($income->date)->format('Y-m-d') }}</td>
                    <td>{{ number_format($income->amount ?? 0, 2) }}</td>
                    <td>{{ $income->description ?? '-' }}</td>
                </tr>
            @endforeach
        </tbody>
    </table>
</body>
</html>
