  <!-- Modal Background -->
    <div id="incomeModal" class="fixed inset-0 bg-gray-900 bg-opacity-50 flex items-center justify-center z-50 hidden">

        <!-- Modal Container -->
        <div class="bg-white rounded-lg shadow-lg w-96 max-h-[80vh] overflow-y-auto">
            <form action="{{ route('income.store') }}" method="POST" class="p-5" enctype="multipart/form-data">
                @csrf
                <!-- Modal Header -->
                <div class="flex justify-between items-center border-b px-4 py-3">
                    <h2 class="text-lg font-semibold">Create New Income</h2>
                    <button type="button" onclick="closeModal()" class="text-gray-500 hover:text-gray-700 text-xl"><i
                            class="fa-solid fa-xmark"></i></button>
                </div>

                <!-- Modal Body -->
                <div class="mt-4 space-y-4 px-4 py-2">
                    <!-- Expense Head -->
                    <select class="w-full border rounded-lg p-2 mt-1" name="incomeCatg" id="incomeCatg" required>
                        <option value="">Select category</option>
                        @foreach ($categories as $category)
                            <option value="{{ $category->head_code }}">{{ $category->name }}</option>
                        @endforeach
                    </select>
                </div>

                <!-- Date -->
                <div>
                    <label class="block text-sm font-medium text-gray-700">Date</label>
                    <input type="date" id="date" name="date" class="w-full border rounded-lg p-2 mt-1" />
                </div>

                <!-- Amount -->
                <div>
                    <label class="block text-sm font-medium text-gray-700">Amount</label>
                    <input type="number" id="amount" name="amount" placeholder="Enter amount"
                        class="w-full border rounded-lg p-2 mt-1" />
                </div>

                <!-- Attachment -->
                <div>
                    <label class="block text-sm font-medium text-gray-700">Attachment (optional)</label>
                    <div
                        class="relative flex items-center justify-center border border-gray-300 rounded-lg p-3 mt-1 cursor-pointer hover:bg-gray-100">
                        <input type="file" id="fileInput" name="fileInput" class="hidden" />
                        <label for="fileInput"
                            class="flex items-center gap-2 cursor-pointer text-blue-600 hover:text-blue-700">
                            <i class="fa-solid fa-upload"></i> Upload
                        </label>
                    </div>
                </div>


                <!-- Description -->
                <div>
                    <label class="block text-sm font-medium text-gray-700">Description</label>
                    <textarea placeholder="Enter description" id="desc" name="desc"
                        class="w-full border rounded-lg p-2 mt-1 h-20"></textarea>
                </div>


                <!-- Modal Footer -->
                <div class="flex justify-end gap-2 mt-6 border-t py-4 pr-3">
                    <button onclick="closeModal()"
                        class="px-4 py-2 border rounded-sm text-gray-600 hover:bg-gray-100">Cancel</button>
                    <button type="submit"
                        class="px-4 py-2 bg-blue-500 text-white rounded-lg hover:bg-blue-600">Save</button>
                </div>
            </form>
        </div>

    </div>
