<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Income Modal</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script
    src="https://kit.fontawesome.com/ee244dc737.js"
    crossorigin="anonymous"
  ></script>
</head>
<body class="flex items-center justify-center h-screen bg-gray-100">

    <!-- Button to Open Modal -->
    <button onclick="openModal()" class="px-4 py-2 bg-blue-500 text-white rounded-lg hover:bg-blue-600">
        Create new Income
    </button>

    <!-- Modal Background -->
    <div id="incomeModal" class="fixed inset-0 bg-gray-900 bg-opacity-50 flex items-center justify-center z-50 ">
        <!-- Modal Container -->
        <div class="bg-white rounded-lg shadow-lg w-96 max-h-[80vh] overflow-y-auto">
            <!-- Modal Header -->
            <div class="flex justify-between items-center border-b px-4 py-3">
                <h2 class="text-lg font-semibold">Create New Income</h2>
                <button onclick="closeModal()" class="text-gray-500 hover:text-gray-700 text-xl"><i class="fa-solid fa-xmark"></i></button>
            </div>

            <!-- Modal Body -->
            <div class="mt-4 space-y-4 px-4 py-2">
                <!-- Expense Head -->
                <div>
                    <label class="block text-sm font-medium text-gray-700">Income Head</label>
                    <select class="w-full border rounded-lg p-2 mt-1">
                        <option>Select category</option>
                    </select>
                </div>

                <!-- Expense Name -->
                <div>
                    <label class="block text-sm font-medium text-gray-700">Name</label>
                    <input type="text" placeholder="Enter expense name" class="w-full border rounded-lg p-2 mt-1" />
                </div>

                <!-- Date -->
                <div>
                    <label class="block text-sm font-medium text-gray-700">Date</label>
                    <input type="date" class="w-full border rounded-lg p-2 mt-1" />
                </div>

                <!-- Amount -->
                <div>
                    <label class="block text-sm font-medium text-gray-700">Amount</label>
                    <input type="number" placeholder="Enter amount" class="w-full border rounded-lg p-2 mt-1" />
                </div>

                <!-- Attachment -->
                <div>
                    <label class="block text-sm font-medium text-gray-700">Attachment (optional)</label>
                    <div class="relative flex items-center justify-center border border-gray-300 rounded-lg p-3 mt-1 cursor-pointer hover:bg-gray-100">
                        <input type="file" id="fileInput" class="hidden" />
                        <label for="fileInput" class="flex items-center gap-2 cursor-pointer text-blue-600 hover:text-blue-700">
                            <i class="fa-solid fa-upload"></i> Upload
                        </label>
                    </div>
                </div>
                

                <!-- Description -->
                <div>
                    <label class="block text-sm font-medium text-gray-700">Description</label>
                    <textarea placeholder="Enter description" class="w-full border rounded-lg p-2 mt-1 h-20"></textarea>
                </div>
            </div>

            <!-- Modal Footer -->
            <div class="flex justify-end gap-2 mt-6 border-t py-4 pr-3">
                <button onclick="closeModal()" class="px-4 py-2 border rounded-sm text-gray-600 hover:bg-gray-100">Cancel</button>
                <button class="px-4 py-2 bg-blue-500 text-white rounded-lg hover:bg-blue-600">Save Income</button>
            </div>
        </div>
    </div>

    <script>
        function openModal() {
            document.getElementById("incomeModal").classList.remove("hidden");
        }

        function closeModal() {
            document.getElementById("incomeModal").classList.add("hidden");
        }
    </script>

</body>
</html>
