@extends('schoolLayout.app')
@section('content')
    @include('successError')

    <div class="px-6 py-4 bg-[#f9fafc] min-h-screen">

        <!-- Header Section -->
        <div class="flex justify-between items-center mb-6">
            @include('income.head')
            <button onclick="openModal()" class="bg-[#0197FF] text-white px-4 py-2 rounded-md hover:bg-blue-600">
                Create New Income
            </button>
        </div>

        <!-- Filters -->
        <form method="GET" class="bg-white p-4 rounded-lg mb-6 flex flex-wrap gap-4 shadow-sm">
            <!-- Search Field -->
            <div class="relative flex-1 min-w-[200px]">
                <img src="{{ asset('assets/search.png') }}" class="absolute left-3 top-1/2 transform -translate-y-1/2 w-4 h-4" />
                <input type="text" name="search" value="{{ request('search') }}" placeholder="Search Description"
                       class="pl-10 pr-3 py-2 w-full border rounded-md shadow-sm focus:outline-none focus:ring focus:ring-blue-200" />
            </div>

            <!-- Date Field -->
            <input type="date" name="date" value="{{ request('date') }}"
                   class="border rounded-md px-3 py-2 shadow-sm focus:outline-none focus:ring focus:ring-blue-200" />

            <!-- Category Dropdown -->
            <select name="category"
                    class="border rounded-md px-3 py-2 shadow-sm focus:outline-none focus:ring focus:ring-blue-200">
                <option value="">All Categories</option>
                @foreach ($categories as $cat)
                    <option value="{{ $cat->head_code }}" {{ request('category') == $cat->head_code ? 'selected' : '' }}>
                        {{ $cat->name }}
                    </option>
                @endforeach
            </select>

            <!-- Filter Button -->
            <button type="submit"
                    class="bg-[#0197FF] text-white px-4 py-2 rounded-md hover:bg-blue-600 transition-all">
                Filter
            </button>

            <!-- Export PDF -->
            <a href="{{ route('income.pdf', request()->query()) }}"
               class="bg-[#0197FF] text-white px-4 py-2 rounded-md hover:bg-blue-600 transition-all">
                Export PDF
            </a>
        </form>

        <!-- Table Section -->
        <div class="bg-white shadow-sm rounded-lg overflow-x-auto">
            @include('income.partialIncomeView', ['incomeDetails' => $incomeDetails])
        </div>

    </div>

    @include('income.incomeModel')

    <!-- Modal Scripts -->
    <script>
        function openModal() {
            document.getElementById("incomeModal").classList.remove("hidden");
        }

        function closeModal() {
            document.getElementById("incomeModal").classList.add("hidden");
        }

        document.addEventListener("click", function (event) {
            if (!event.target.closest(".action-btn")) {
                document.querySelectorAll(".action-dropdown").forEach((dropdown) => {
                    dropdown.classList.add("hidden");
                });
            }
        });

        function toggleDropdown(button) {
            document.querySelectorAll(".action-dropdown").forEach((dropdown) => {
                if (dropdown !== button.nextElementSibling) {
                    dropdown.classList.add("hidden");
                }
            });
            button.nextElementSibling.classList.toggle("hidden");
        }
    </script>
@endsection
