<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="UTF-8" />
    <link rel="shortcut icon" href="{{asset('assets/favicon.svg')}}" />
    <meta name="description" content="Landing Page for School Management System" />
    <meta name="csrf-token" content="{{ csrf_token() }}" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>{{ config('app.title') }}</title>
    </title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script
      src="https://kit.fontawesome.com/ee244dc737.js"
      crossorigin="anonymous"
    ></script>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@300;400;500;700&display=swap" rel="stylesheet">

  </head>
  <body class="font-[Roboto]">
    <nav class="bg-white shadow-md border-b">
        <div class="max-w-7xl mx-auto px-6 py-4 flex justify-between items-center">
            
            <!-- Left: Logo + Nav Links -->
            <div class="flex items-center space-x-8">
                <!-- Logo -->
                <img src="{{ !empty($school->setting_value) ? url('school-logo/' . $school->setting_value) : asset('assets/logo.svg') }}" alt="logo" class="w-14" />

                
 

                <!-- Desktop Menu -->
                <ul class="hidden md:flex space-x-6">
                    <li><a href="#" class="text-gray-700 hover:text-blue-500 border-b-2 border-transparent hover:border-blue-500 pb-1">Home</a></li>
                    <li><a href="#" class="text-gray-700 hover:text-blue-500 border-b-2 border-transparent hover:border-blue-500 pb-1">Features</a></li>
                    <li><a href="#" class="text-gray-700 hover:text-blue-500 border-b-2 border-transparent hover:border-blue-500 pb-1">Pricing</a></li>
                    <li><a href="#" class="text-gray-700 hover:text-blue-500 border-b-2 border-transparent hover:border-blue-500 pb-1">Contact</a></li>
                </ul>
            </div>

            <!-- Right: Buttons -->
            <div class="hidden md:flex space-x-4">
            @auth
            <!-- Logout Form -->
            <form action="{{ route('logout') }}" method="POST">
              @csrf
              <button type="submit" class="px-6 py-2 border border-gray-400 text-gray-600 rounded-md">Logout</button>
            </form>
          @else
            <a href="{{ route('login') }}" class="px-6 py-2 border border-gray-400 text-gray-600 rounded-md">Sign In</a>
          @endauth
          <a href="#" class="px-4 py-2 bg-[#1B9AF5] text-white rounded-md hover:bg-blue-700">Create School</a>
            </div>

            <!-- Mobile Menu Button -->
            <button class="md:hidden text-gray-700 focus:outline-none" onclick="toggleMenu()">
                <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16m-7 6h7"></path>
                </svg>
            </button>
        </div>

        <!-- Mobile Menu -->
        <div id="mobile-menu" class="hidden bg-white shadow-md absolute top-0 left-0 w-full h-full flex flex-col items-center justify-center space-y-6">
            <!-- Close Button -->
            <button class="absolute top-4 right-6 text-gray-700" onclick="toggleMenu()">
                <svg class="w-8 h-8" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                </svg>
            </button>

            <!-- Mobile Nav Links -->
            <ul class="text-center space-y-4">
                <li><a href="#" class="text-gray-700 text-lg hover:text-blue-500">Home</a></li>
                <li><a href="#" class="text-gray-700 text-lg hover:text-blue-500">Features</a></li>
                <li><a href="#" class="text-gray-700 text-lg hover:text-blue-500">Pricing</a></li>
                <li><a href="#" class="text-gray-700 text-lg hover:text-blue-500">Contact</a></li>
            </ul>

            <!-- Mobile Buttons -->
            <div class="flex flex-col space-y-3">
            @auth
            <form action="{{ route('logout') }}" method="POST">
              @csrf
              <button type="submit" class="px-6 py-2 border border-gray-400 text-gray-600 text-center rounded-md">Logout</button>
            </form>
          @else
            <a href="{{ route('login') }}" class="px-6 py-2 border border-gray-400 text-gray-600 text-center rounded-md">Sign In</a>
          @endauth
          <a href="#" class="px-4 py-2 bg-[#1B9AF5] text-white rounded-md hover:bg-blue-700">Create School</a>
            </div>
        </div>
    </nav>
    <section class="bg-white">
      <div
        class="max-w-7xl mx-auto px-6 lg:px-12 py-8 md:py-16 flex flex-col lg:flex-row items-center gap-8"
      >
        <!-- Left Content -->
        <div class="lg:w-1/2 text-center lg:text-left">
          <h1
            class="text-5xl md:text-5xl font-bold text-[#111827]"
          >
            Empowering Schools <br>
            <span class="text-[#1B9AF5]">with Smart Solutions</span>
          </h1>

          <p class="text-gray-600 mt-4 text-lg">
            Streamline admissions, attendance, exams, and staff management with
            our all-in-one platform designed for modern educational
            institutions.
          </p>
          <!-- Buttons -->
          <div
            class="mt-6 flex flex-col sm:flex-row justify-center lg:justify-start gap-4"
          >
            <a
              href="#"
              class="bg-[#1B9AF5] text-white px-6 py-3 rounded-lg font-semibold shadow-md hover:bg-blue-700 transition duration-300"
            >
              Create a school
            </a>
            <a
              href="#"
              class="border border-gray-200 text-gray-900 px-6 py-3 rounded-lg font-semibold shadow-md flex items-center justify-center gap-x-2 transition duration-300"
            >
              <i class="fa-solid fa-circle-play"></i>
              Watch Demo
            </a>
          </div>
        </div>

        <!-- Right Image -->
        <div class="lg:w-1/2">
          <img
            src="{{ asset('assets/heroImage.png') }}"
            alt="School Illustration"
            class="w-full"
          />
        </div>
      </div>
    </section>
    <section class="bg-[#F9FAFB] py-10 w-full text-center">
      <div class="w-full md:max-w-6xl px-4 md:px-0 mx-auto">
        <!-- Section Heading -->
        <h2
          class="text-3xl md:text-4xl text-[#111827] font-bold text-gray-800 mb-6"
        >
          Powerful Features
        </h2>
        <p class="text-gray-600 max-w-2xl mx-auto mb-10">
          Everything you need to manage your educational institution
          efficiently.
        </p>

        <!-- Features Grid -->
        <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 gap-6">
          <!-- Feature Card -->
          <div
            class="bg-white p-6 rounded-lg shadow-md flex flex-col items-start hover:shadow-lg transition"
          >
            <i
              class="fa-solid fa-user-graduate text-4xl text-[#1B9AF5] mb-4"
            ></i>
            <h3 class="font-semibold text-lg">Student Management</h3>
            <p class="text-gray-600 text-sm text-left mt-2">
              Complete student lifecycle management from admission to
              graduation.
            </p>
          </div>

          <div
            class="bg-white p-6 rounded-lg shadow-md flex flex-col items-start hover:shadow-lg transition"
          >
            <i
              class="fa-solid fa-calendar-check text-4xl text-[#1B9AF5] mb-4"
            ></i>
            <h3 class="font-semibold text-lg">Attendance Tracking</h3>
            <p class="text-gray-600 text-sm text-left mt-2">
              Automated attendance management with real-time reporting.
            </p>
          </div>

          <div
            class="bg-white p-6 rounded-lg shadow-md flex flex-col items-start hover:shadow-lg transition"
          >
            <i class="fa-solid fa-chart-line text-4xl text-[#1B9AF5] mb-4"></i>
            <h3 class="font-semibold text-lg">Performance Analytics</h3>
            <p class="text-gray-600 text-sm text-left mt-2">
              Comprehensive analytics and reporting tools for better insights.
            </p>
          </div>

          <div
            class="bg-white p-6 rounded-lg shadow-md flex flex-col items-start hover:shadow-lg transition"
          >
            <i class="fa-solid fa-book-open text-4xl text-[#1B9AF5] mb-4"></i>
            <h3 class="font-semibold text-lg">Course Management</h3>
            <p class="text-gray-600 text-sm text-left mt-2">
              Organize and manage courses, assignments, and materials.
            </p>
          </div>

          <div
            class="bg-white p-6 rounded-lg shadow-md flex flex-col items-start hover:shadow-lg transition"
          >
            <i class="fa-solid fa-comments text-4xl text-[#1B9AF5] mb-4"></i>
            <h3 class="font-semibold text-lg">Communication Tools</h3>
            <p class="text-gray-600 text-sm text-left mt-2">
              Stay connected with students, parents, and staff.
            </p>
          </div>

          <div
            class="bg-white p-6 rounded-lg shadow-md flex flex-col items-start hover:shadow-lg transition"
          >
            <i class="fa-solid fa-shield-alt text-4xl text-[#1B9AF5] mb-4"></i>
            <h3 class="font-semibold text-lg">Secure & Reliable</h3>
            <p class="text-gray-600 text-sm text-left mt-2">
              Enterprise-grade security and 99.9% uptime guarantee
            </p>
          </div>
        </div>
      </div>
    </section>
    <section class="bg-white py-10 w-full text-center">
      <div class="w-full md:max-w-6xl px-4 md:px-0 mx-auto">
        <h2 class="text-3xl md:text-4xl font-bold text-[#111827] mb-6">
          Trusted by Leading Institutions
        </h2>

        <!-- Testimonials Grid -->
        <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 gap-6">
            <div class="bg-[#F9FAFB] p-6 rounded-lg shadow-sm flex flex-col hover:shadow-lg transition">
                <div class="flex gap-x-4 items-center">
                    <div class="bg-gray-300 w-10 h-10 flex items-center justify-center rounded-full">
                        <i class="fa-solid fa-user text-lg text-gray-700"></i>
                    </div>
                    <div class="flex flex-col text-left">
                        <h3 class="font-semibold text-lg">Sarah Johnson</h3>
                        <p class="text-gray-500 text-sm">Principal, Lincoln High School</p>
                    </div>
                </div>
                <p class="text-gray-600 mt-3 text-left text-sm">
                    "This system has revolutionized how we manage our school. The automation and analytics have saved us countless hours of work."
                </p>
            </div>

            <!-- Testimonial 2 -->
            <div class="bg-[#F9FAFB] p-6 rounded-lg shadow-sm flex flex-col hover:shadow-lg transition">
                <div class="flex gap-x-4 items-center">
                    <div class="bg-gray-300 w-10 h-10 flex items-center justify-center rounded-full">
                        <i class="fa-solid fa-user text-lg text-gray-700"></i>
                    </div>
                    <div class="flex flex-col text-left">
                        <h3 class="font-semibold text-lg">Michael Chen</h3>
                        <p class="text-gray-500 text-sm">Director, Global Academy</p>
                    </div>
                </div>
                <p class="text-gray-600 mt-3 text-left text-sm">
                    "The delegation capabilities and security features are outstanding. It’s exactly what we needed for our growing institution."
                </p>
            </div>

            <!-- Testimonial 3 -->
            <div class="bg-[#F9FAFB] p-6 rounded-lg shadow-sm flex flex-col hover:shadow-lg transition">
                <div class="flex gap-x-4 items-center">
                    <div class="bg-gray-300 w-10 h-10 flex items-center justify-center rounded-full">
                        <i class="fa-solid fa-user text-lg text-gray-700"></i>
                    </div>
                    <div class="flex flex-col text-left">
                        <h3 class="font-semibold text-lg">Emily Rodriguez</h3>
                        <p class="text-gray-500 text-sm">Administrator, Sunshine University</p>
                    </div>
                </div>
                <p class="text-gray-600 mt-3 text-left text-sm">
                    "The parent portal and communication tools have greatly improved our engagement with families. Highly recommended!"
                </p>
            </div>
        </div>
      </div>
    </section>
    <section class="bg-[#F9FAFB] flex items-center justify-center flex-col rounded-lg shadow-md px-6 py-12 w-full text-center">
        <!-- Heading -->
        <h2 class="text-3xl md:text-4xl font-bold text-gray-800">
            Ready to Transform Your School?
        </h2>
        
        <!-- Subheading -->
        <p class="text-gray-600 mt-3 text-lg">
            Join thousands of schools already using our platform.
        </p>

        <!-- CTA Button -->
        <a href="#" class="mt-5 inline-block bg-[#1B9AF5] text-white text-lg px-6 py-3 rounded-lg flex items-center gap-x-2 shadow-md hover:bg-[#1577C0] transition">
            Start Free Trial <i class="fa-solid fa-arrow-right mt-1"></i>
        </a>
    </section>
    <footer class="bg-[#1F2937] text-gray-300 py-10">
        <div class="max-w-6xl mx-auto px-6">
            <!-- Footer Grid -->
            <div class="grid grid-cols-2 md:grid-cols-4 gap-8 border-b border-gray-700 pb-6">
                
                <!-- Product -->
                <div>
                    <h3 class="text-lg font-semibold text-white mb-3">Product</h3>
                    <ul class="space-y-2">
                        <li><a href="#" class="hover:text-blue-400">Features</a></li>
                        <li><a href="#" class="hover:text-blue-400">Pricing</a></li>
                        <li><a href="#" class="hover:text-blue-400">Security</a></li>
                    </ul>
                </div>

                <!-- Support -->
                <div>
                    <h3 class="text-lg font-semibold text-white mb-3">Support</h3>
                    <ul class="space-y-2">
                        <li><a href="#" class="hover:text-blue-400">Documentation</a></li>
                        <li><a href="#" class="hover:text-blue-400">Guides</a></li>
                        <li><a href="#" class="hover:text-blue-400">Help Center</a></li>
                    </ul>
                </div>

                <!-- Company -->
                <div>
                    <h3 class="text-lg font-semibold text-white mb-3">Company</h3>
                    <ul class="space-y-2">
                        <li><a href="#" class="hover:text-blue-400">About</a></li>
                        <li><a href="#" class="hover:text-blue-400">Blog</a></li>
                        <li><a href="#" class="hover:text-blue-400">Careers</a></li>
                    </ul>
                </div>

                <!-- Legal -->
                <div>
                    <h3 class="text-lg font-semibold text-white mb-3">Legal</h3>
                    <ul class="space-y-2">
                        <li><a href="#" class="hover:text-blue-400">Privacy</a></li>
                        <li><a href="#" class="hover:text-blue-400">Terms</a></li>
                        <li><a href="#" class="hover:text-blue-400">Cookie Policy</a></li>
                    </ul>
                </div>

            </div>

            <!-- Footer Bottom Row -->
            <div class="flex flex-col md:flex-row items-center justify-between mt-6">
                 <!-- Copyright -->
                 <p class="text-gray-400 text-sm mt-4 md:mt-0">
                    © 2025 School Management System. All rights reserved.
                </p>
                
                <!-- Social Icons -->
                <div class="flex space-x-4 mt-4 md:mt-0">
                    <a href="#" class="text-gray-400 hover:text-blue-400"><i class="fab fa-facebook-f"></i></a>
                    <a href="#" class="text-gray-400 hover:text-blue-400"><i class="fab fa-twitter"></i></a>
                    <a href="#" class="text-gray-400 hover:text-blue-400"><i class="fab fa-linkedin-in"></i></a>
                </div>

               
                
            </div>
        </div>
    </footer>
    <script>
        function toggleMenu() {
            document.getElementById("mobile-menu").classList.toggle("hidden");
        }
    </script>
  </body>
</html>
