@extends('schoolLayout.app')
@section('content')

@include('successError')

    <div class="bg-[#f9fafc] min-h-screen px-8 py-4">
        <form action="{{ route('expenses.store') }}" method="POST" enctype="multipart/form-data">
            @csrf
            <div class="border border-gray-200 rounded-lg mt-4">
                <!-- Filters Section -->
                <div class="bg-white p-3 flex justify-between rounded-lg flex-wrap gap-4">
                    <div class="flex gap-x-2 items-center">
                        <label for="totalAmount" class="text-gray-500 font-medium">Date</label>
                        <input type="date" id="date" name="date" class="p-2 border rounded-md bg-[#F9FAFB]"
                            required>
                    </div>
                </div>
                <div class="relative bg-white">
                    <table class="w-full border-collapse" id="expenseTable">
                        <thead class="bg-[#f9fafc]">
                            <tr class="text-gray-600">
                                <th class="p-3 text-left text-gray-500 font-medium">Expense Head</th>
                                <th class="p-3 text-left text-gray-500 font-medium">Amount</th>
                                <th class="p-3 text-left text-gray-500 font-medium">Attachment</th>
                                <th class="p-3 text-left text-gray-500 font-medium">Description</th>
                            </tr>
                        </thead>
                        <tbody class="bg-white py-3 rounded-lg">
                            <!-- Initial Row -->
                            <tr class="border-b border-gray-200">
                                <!-- Select Input -->
                                <td class="p-2">
                                    <select name="expense_head[]"
                                        class="w-full p-2 bg-[#F9FAFB] border rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500"
                                        required>
                                        <option value="">Select Category</option>
                                        @if ($categories)
                                            @foreach ($categories as $category)
                                                <option value="{{ $category->head_code }}">{{ $category->name }}</option>
                                            @endforeach
                                        @endif
                                    </select>
                                </td>
                                <!-- Number Input -->
                                <td class="p-2">
                                    <input type="number" name="expense_amount[]" placeholder="0.00"
                                        class="w-full p-2 bg-[#F9FAFB] max-w-[100px] border rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500 amount-input"
                                        required>
                                </td>
                                <!-- Attach File Input -->
                                <td class="p-2">
                                    <label
                                        class="inline-flex bg-[#F9FAFB] p-2 rounded-md border border-gray-400 justify-center text-gray-500 items-center gap-2 cursor-pointer">
                                        <input type="file" name="expense_attachment[]" class="hidden">
                                        <i class="fa-solid fa-upload"></i>
                                    </label>
                                </td>
                                <!-- Description Input -->
                                <td class="p-2">
                                    <input type="text" name="expense_description[]" placeholder="Add description"
                                        class="w-full p-2 bg-[#F9FAFB] border rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                                </td>
                            </tr>
                        </tbody>
                    </table>
                    <!-- Filters Section -->
                    <div class="bg-white p-3 flex justify-between rounded-lg flex-wrap gap-4">
                        <div class="flex gap-x-2 items-center">
                            <!-- Label -->
                            <label for="totalAmount" class="text-gray-500 font-medium">Total Amount</label>
                            <!-- Input Field -->
                            <input type="number" id="totalAmount" name="totalAmount"
                                class="p-2 border rounded-md bg-[#F9FAFB]" readonly>
                        </div>
                    </div>
                    <div class="flex items-center gap-x-4 mt-4 px-4 justify-end">
                        <!-- Add Row Button -->
                        <button type="button" id="addRow"
                            class="flex items-center gap-2 bg-[#6B7280] text-white px-4 py-2 rounded-md transition-all">
                            <i class="fa-solid fa-plus"></i> Add Row
                        </button>
                        <!-- Submit Button -->
                        <button type="submit"
                            class="flex items-center gap-2 bg-[#1B9AF5] text-white px-4 py-2 rounded-lg transition-all">
                            <i class="fa-solid fa-check"></i> Submit
                        </button>
                    </div>
                </div>
            </div>
        </form>
    </div>
@endsection

@section('script')
    <script>
        // Function to calculate the total amount
        function updateTotalAmount() {
            let total = 0;
            document.querySelectorAll('.amount-input').forEach(input => {
                total += parseFloat(input.value) || 0; // Add the amount or 0 if the input is empty
            });
            document.getElementById('totalAmount').value = total.toFixed(2); // Update the total amount field
        }

        // Add event listeners to all amount inputs
        document.querySelectorAll('.amount-input').forEach(input => {
            input.addEventListener('input', updateTotalAmount);
        });

        // Add Row Button Logic
        document.getElementById('addRow').addEventListener('click', function() {
            const tableBody = document.querySelector('#expenseTable tbody');
            const lastRow = tableBody.lastElementChild;

            // Check if all fields in the last row are filled
            const inputs = lastRow.querySelectorAll('input, select');
            let isFilled = true;
            inputs.forEach(input => {
                if (input.required && !input.value) {
                    isFilled = false;
                    input.classList.add('border-red-500'); // Highlight empty fields
                } else {
                    input.classList.remove('border-red-500');
                }
            });

            if (!isFilled) {
                alert('Please fill all fields in the current row before adding a new one.');
                return;
            }

            // Clone the last row and append it to the table
            const newRow = lastRow.cloneNode(true);
            newRow.querySelectorAll('input').forEach(input => input.value = ''); // Clear input values
            tableBody.appendChild(newRow);

            // Add event listener to the new amount input
            newRow.querySelector('.amount-input').addEventListener('input', updateTotalAmount);
        });
    </script>
@endsection
