<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>{{ $examTitle }} Timetable</title>
    <style>
        body {
            font-family: DejaVu Sans, sans-serif;
            font-size: 10px;
            margin: 10px;
        }
        .header {
            text-align: center;
            margin-bottom: 15px;
        }
        .header h1 {
            font-size: 20px;
            margin: 0;
        }
        .header p {
            margin: 2px 0;
            font-size: 10px;
        }
        h2 {
            font-size: 18px;
            margin-bottom: 10px;
            text-align: center;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            text-align: center;
            table-layout: fixed;
        }
        th, td {
            border: 1px solid #d1d5db;
            padding: 4px;
            word-wrap: break-word;
        }
        thead {
            background-color: #f9fafc;
        }
        th {
            color: #374151;
            font-weight: 600;
        }
        .table-container {
            overflow-x: auto;
            width: 100%;
        }
    </style>
</head>
<body>

    <div class="header">
        <h1>{{ $schoolName ?? 'Your School Name Here' }}</h1>
        <p>{{ $schoolAddress ?? '123 Main Street, City, Country' }}</p>
        <p><strong>Academic Year:</strong> {{ $academicYear ?? '2024-2025' }}</p>
    </div>

    <h2>{{ $examTitle }} Timetable</h2>

    <div class="table-container">
        <table>
            <thead>
                <tr>
                    <th style="width: 12%">Date</th>
                    <th style="width: 10%">Day</th>
                    @foreach($classes as $class)
                        <th style="width: {{ 78/count($classes) }}%">{{ $class }}</th>
                    @endforeach
                </tr>
            </thead>
            <tbody>
                @foreach($schedule as $day)
                    <tr>
                        <td>{{ $day['date'] }}</td>
                        <td>{{ $day['day'] }}</td>
                        @foreach($classes as $className)
                            @php
                                $classData = collect($day['classes'])->firstWhere('className', $className);
                                $subject = $classData['subject']['name'] ?? '-';
                            @endphp
                            <td>{{ $subject }}</td>
                        @endforeach
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>

</body>
</html>
