@extends('schoolLayout.app')
@section('content')

    @if (session('error'))
        <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded relative mb-4" role="alert">
            <strong class="font-bold">Error:</strong>
            <span class="block sm:inline">{{ session('error') }}</span>
        </div>
    @endif

    @if (session('success'))
        <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded relative mb-4" role="alert">
            <strong class="font-bold">Success:</strong>
            <span class="block sm:inline">{{ session('success') }}</span>
        </div>
    @endif

    <div class="bg-[#f9fafc] min-h-screen px-8 py-4">
        <!-- Top Section: Tabs & Button -->
        <div class="flex justify-between items-center">
            <!-- Tabs:-->
            <button class="px-4 py-2 bg-[#0197FF] flex items-center gap-x-4 text-white rounded-md" id="openModal">
                <i class="fa-solid fa-plus"></i>
                <span>Add New Exam Hall</span>
            </button>
        </div>

        <div class="border p-3 bg-white border-gray-200 rounded-lg my-4">

            <div class="relative bg-white">
                <table class="w-full border-collapse">
                    <thead class="bg-[#f9fafc]">
                        <tr class="text-gray-600">
                            <th class="p-3 text-left text-gray-500 font-medium">Hall Name</th>
                             <th class="p-3 text-left text-gray-500 font-medium">Hall Capicity</th>
                             <th class="p-3 text-left text-gray-500 font-medium">Location</th>
                             <th class="p-3 text-left text-gray-500 font-medium">Notes</th>
                              <th class="p-3 text-left text-gray-500 font-medium">
                                Actions
                            </th>
                        </tr>
                    </thead>
                    <tbody class="bg-white py-3 rounded-lg">
                        @if ($all_exam_halls)
                            @foreach ($all_exam_halls as $hall)
                                <tr class="border-b">
                                   
                                     <td class="p-3 text-gray-700">{{ $hall->name }}</td>
                                    <td class="p-3 text-gray-700">{{ $hall->capacity }}</td>
                                    <td class="p-3 text-gray-700">{{ $hall->location }}</td>
                                    <td class="p-3 text-gray-700">
                                        {{ Str::limit($hall->notes, 30) }}
                                    </td>
                                    <td class="p-3 flex items-center gap-x-4">
                                        <i class="fa-solid fa-pen-to-square text-blue-500 cursor-pointer"
                                            onclick="openEditModal({
                                        id: '{{ $hall->id }}',
                                        name: '{{ $hall->name }}',
                                        capacity: '{{ $hall->capacity }}',
                                        location: '{{ $hall->location }}',
                                        notes: '{{ $hall->notes }}'
                                    })"></i>
                                        <i class="fa-solid fa-trash text-red-500 cursor-pointer"
                                            data-id="{{ $hall->id }}" onclick="deleteClass(this)"></i>
                                    </td>
                                </tr>
                            @endforeach
                        @endif


                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <!-- Modal Background (Initially Hidden) -->
    <div id="modal" class="fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center hidden">
        <!-- Modal Content -->
        <div class="bg-white w-full max-w-lg rounded-lg shadow-lg relative max-h-[80vh] overflow-y-auto">
            <!-- Modal Header -->
            <div class="flex items-center px-4 py-6 border-b border-gray-200 justify-between">
                <h2 class="text-xl font-semibold">Create New Exam Hall</h2>
                <button type="button" id="closeModal" class="text-gray-600 hover:text-gray-900">
                    <i class="fa-solid fa-xmark"></i>
                </button>
            </div>

            <!-- Modal Body -->
            <form class="bg-white px-6 py-3" action="{{ route('exam.hall.store') }}" method="post">
                @csrf
                <!-- Class Name -->
                <div class="mb-4">
                    <label class="block text-gray-700 font-semibold mb-1">
                    Hall Name <span class="text-red-500">*</span>
                    </label>
                    <input required type="text" placeholder="HALL A" name="name"
                        class="w-full border border-gray-300 p-2 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500" />
                </div>

                <div class="mb-4">
                    <label class="block text-gray-700 font-semibold mb-1">
                    Hall Location <span class="text-red-500">*</span>
                    </label>
                    <input required type="text" placeholder="Main Building, Room 101" name="location"
                        class="w-full border border-gray-300 p-2 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500" />
                </div>

                <!--   -->
                <div class="mb-4">
                    <label class="block text-gray-700 font-semibold mb-1">
                    Hall Capicity <span class="text-red-500">*</span>
                    </label>
                    <input required type="number" placeholder="30,40,50" name="capacity"
                        class="w-full border border-gray-300 p-2 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500" />
                </div>

                <!-- Description Code -->
                 <div class="mb-4">
                    <label class="block text-gray-700 font-semibold mb-1">
                        Notes <span class="text-red-500">*</span>
                    </label>
                    <textarea name="notes" rows="4" placeholder="notes"
                        class="w-full border border-gray-300 p-2 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500" required></textarea>
                </div>


                <!-- Modal Footer -->
                <div class="flex justify-end border-t border-gray-200 bg-[#f9fafc] px-6 py-3 space-x-3">
                    <button id="closeModalBtn" type="button"
                        class="px-4 py-2 border border-gray-500 text-gray-800 rounded">
                        Cancel
                    </button>
                    <button type="submit" class="px-4 py-2 bg-[#0197FF] text-white rounded hover:bg-blue-700">
                        Create Exam Hall
                    </button>
                </div>
            </form>
        </div>
    </div>

  {{-- Edit modal  --}}
    <div id="editModal" class="fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center hidden">
        <div class="bg-white w-full max-w-lg rounded-lg shadow-lg relative max-h-[80vh] overflow-y-auto">
            <div class="flex items-center px-4 py-6 border-b border-gray-200 justify-between">
                <h2 class="text-xl font-semibold">Edit Exam</h2>
                <button onclick="closeModal()" class="text-gray-600 hover:text-gray-900">
                    <i class="fa-solid fa-xmark"></i>
                </button>
            </div>

            <form id="editExamHallForm" method="POST" class="bg-white px-6 py-3">
                @csrf
                <input type="hidden" name="_method" value="PUT">
                <input type="hidden" id="editExamHallId" name="id">

                <div class="mb-4">
                    <label class="block text-gray-700 font-semibold mb-1">
                        Exam Hall Name <span class="text-red-500">*</span>
                    </label>
                    <input type="text" id="editExamHallName" name="name"
                        class="w-full border border-gray-300 p-2 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500"
                        required>
                </div>

                <div class="mb-4">
                    <label class="block text-gray-700 font-semibold mb-1">
                        Exam Hall Location <span class="text-red-500">*</span>
                    </label>
                    <input type="text" id="editExamHallLocation" name="location"
                        class="w-full border border-gray-300 p-2 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500"
                        required>
                </div>
               
                <div class="mb-4">
                    <label class="block text-gray-700 font-semibold mb-1">
                    Hall Capicity <span class="text-red-500">*</span>
                    </label>
                    <input required type="number" id="editExamHallCapacity" placeholder="30,40,50" name="capacity"
                        class="w-full border border-gray-300 p-2 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500" />
                </div>

                <div class="mb-4">
                    <label class="block text-gray-700 font-semibold mb-1">
                        Notes <span class="text-red-500">*</span>
                    </label>
                    <textarea id="editExamHallDescription" name="notes" rows="4" placeholder="Description"
                        class="w-full border border-gray-300 p-2 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500"
                        required></textarea>
                </div>

                <div class="flex justify-end border-t border-gray-200 bg-[#f9fafc] px-6 py-3 space-x-3">
                    <button type="button" onclick="closeModal()"
                        class="px-4 py-2 border border-gray-500 text-gray-800 rounded">
                        Cancel
                    </button>
                    <button type="submit" class="px-4 py-2 bg-[#0197FF] text-white rounded hover:bg-blue-700">
                        Update Exam Hall
                    </button>
                </div>
            </form>
        </div>
    </div>




    <script>
        // Modal functionality
        const modal = document.getElementById("modal");
        const openModalBtn = document.getElementById("openModal");
        const closeModalBtns = [
            document.getElementById("closeModal"),
            document.getElementById("closeModalBtn"),
        ];

        openModalBtn.addEventListener("click", () => {
            modal.classList.remove("hidden");
        });

        closeModalBtns.forEach((btn) => {
            btn.addEventListener("click", () => {
                modal.classList.add("hidden");
            });
        });


        function openEditModal(classData) {
            document.getElementById('editExamHallName').value = classData.name;
            document.getElementById('editExamHallLocation').value = classData.location; // Fixed ID
            document.getElementById('editExamHallCapacity').value = classData.capacity; // Fixed ID
            document.getElementById('editExamHallDescription').value = classData.notes;
            document.getElementById('editExamHallForm').action = `/exam/hall/update/${classData.id}`;
            document.getElementById('editModal').classList.remove('hidden');
        }

        function closeModal() {
            document.getElementById('editModal').classList.add('hidden');
        }

        function deleteClass(element) {
            if (confirm('Are you sure you want to delete this Exam?')) {
                let a = document.createElement('a');
                a.href = `/exam/hall/delete/${element.dataset.id}`;
                a.click();
            }
        }

        // Close modal when clicking outside
        document.addEventListener('DOMContentLoaded', function() {
            window.onclick = function(event) {
                const modal = document.getElementById('editModal');
                if (event.target === modal) {
                    closeModal();
                }
            }
        });
    </script>



@endsection
