@extends('schoolLayout.app')
@section('content')
{{-- Success Message --}}
@if (session('success'))
    <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded relative mb-4" role="alert" id="success-alert">
        <strong class="font-bold">Success!</strong>
        <span class="block sm:inline">{{ session('success') }}</span>
        <span class="absolute top-0 bottom-0 right-0 px-4 py-3 cursor-pointer" onclick="document.getElementById('success-alert').style.display='none'">
            <svg class="fill-current h-6 w-6 text-green-500" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20">
                <title>Close</title>
                <path d="M14.348 14.849a1 1 0 01-1.414 0L10 11.414l-2.93 2.93a1 1 0 11-1.414-1.414l2.93-2.93-2.93-2.93a1 1 0 111.414-1.414l2.93 2.93 2.93-2.93a1 1 0 111.414 1.414l-2.93 2.93 2.93 2.93a1 1 0 010 1.414z"/>
            </svg>
        </span>
    </div>
@endif

@if (session('error'))
    <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded relative mb-4" role="alert" id="error-message">
        <strong class="font-bold">Error!</strong>
        <span class="block sm:inline">{{ session('error') }}</span>
        <span class="absolute top-0 bottom-0 right-0 px-4 py-3 cursor-pointer" onclick="document.getElementById('error-message').style.display='none'">
            <svg class="fill-current h-6 w-6 text-red-500" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20">
                <title>Close</title>
                <path d="M14.348 14.849a1 1 0 01-1.414 0L10 11.414l-2.93 2.93a1 1 0 11-1.414-1.414l2.93-2.93-2.93-2.93a1 1 0 111.414-1.414l2.93 2.93 2.93-2.93a1 1 0 111.414 1.414l-2.93 2.93 2.93 2.93a1 1 0 010 1.414z"/>
            </svg>
        </span>
    </div>
@endif


  


    <form class="" method="POST" action="{{ route('exam.timetable.update', $exam->id)  }}">
        @csrf
         @method('PUT')
      <div class="bg-white space-y-6 p-6">
        <h1 class="text-2xl font-bold mb-6">Edit Exam Timetable</h1>

        <!-- Exam Name, Type, Session -->
        <div class="grid md:grid-cols-3 gap-4">
          <div>
            <label class="block text-[#374151] text-lg font-semibold mb-1"
              >Exam Name</label
            >
            <input
              type="text"
              name="name"
                 value="{{ old('name', $exam->title) }}"

              placeholder="Enter exam name"
              class="w-full border border-gray-300 rounded px-3 py-2 focus:outline-none focus:ring focus:ring-blue-200"
            />
          </div>
          <div>
            <label class="block text-[#374151] text-lg font-semibold mb-1"
              >Exam Type</label
            >
            <select
              name="exam_id"
              class="w-full border border-gray-300 rounded px-3 py-2 focus:outline-none focus:ring focus:ring-blue-200"
            >
              <option>Select Exam</option>
              @if($exams->count() > 0)
                @foreach($exams as $exam)
                  <option value="{{ $exam->id }}">{{ $exam->type }}</option>
                @endforeach
                @endif
            </select>
          </div>
          <div>
            <label class="block text-[#374151] text-lg font-semibold mb-1"
              >Academic Session</label
            >
            <select
            name="academic_session"
              class="w-full border border-gray-300 rounded px-3 py-2 focus:outline-none focus:ring focus:ring-blue-200"
            >
              <option>{{$academic_year}}</option>
            </select>
          </div>
        </div>

        <!-- Select Classes -->
        <div>
          <label class="block text-[#374151] text-lg font-semibold mb-2"
            >Select Classes <span class="text-[#f00]">(Only those classes are listed which have Active Students)</span> </label
          > 
          <div
            class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 lg:grid-cols-4 gap-3"
          >
            <!-- Repeat for each class -->
             @if($classes->count() > 0)
                @foreach($classes as $class)
             
                <div class="flex items-center border border-gray-300 rounded p-2">
                  <input 
                      name="class_id[]" 
                      value="{{ $class->id }}" 
                      type="checkbox" 
                      id="class{{ $class->id }}" 
                      class="mr-1 w-4 h-4"
                      {{ array_key_exists($class->id, $schedulesByClass) ? 'checked' : '' }}
                  />
                  <label for="class{{$class->id}}" class="ml-2">{{$class->name}}</label>
                </div>
            @endforeach
            @endif 
          </div>
        </div>

        <!-- Start Date, End Date, Duration -->
        <!-- <div class="grid md:grid-cols-3 gap-4">
          <div>
            <label class="block text-[#374151] text-lg font-semibold mb-1"
              >Start Date</label
            >
            <input
              type="date"
              class="w-full border border-gray-300 rounded px-3 py-2 focus:outline-none focus:ring focus:ring-blue-200"
            />
          </div>
          <div>
            <label class="block text-[#374151] text-lg font-semibold mb-1"
              >End Date</label
            >
            <input
              type="date"
              class="w-full border border-gray-300 rounded px-3 py-2 focus:outline-none focus:ring focus:ring-blue-200"
            />
          </div>
          <div>
            <label class="block text-[#374151] text-lg font-semibold mb-1"
              >Exam Duration</label
            >
            <input
              type="text"
              value="3 hours"
              class="w-full border border-gray-300 rounded px-3 py-2 focus:outline-none focus:ring focus:ring-blue-200"
            />
          </div>
        </div> -->

        <!-- Notes -->
        <div>
          <label class="block text-[#374151] text-lg font-semibold mb-1"
            >Additional Notes</label
          >
          <textarea
          name="special_notes"
          placeholder="Enter any special instructions."
          rows="4"
          class="w-full border border-gray-300 rounded px-3 py-2 focus:outline-none focus:ring focus:ring-blue-200"
      >{{ old('special_notes', $schedulesByClass[$exam->id][0]['special_notes'] ?? '') }}</textarea>
        </div>
      </div>
      <div class="bg-white p-6 mt-10">
        <h2 class="text-2xl font-semibold mb-4">Exam Timetable</h2>
        <div class="overflow-auto rounded">
        <div class="overflow-x-auto"> <!-- Horizontal scroll container -->
            <table class="min-w-full text-sm text-center border-collapse">
                <thead class="bg-[#f9fafc] sticky top-0"> <!-- Make header sticky -->
                <tr>
                    <th class="border-b text-left font-medium text-gray-600 px-4 py-3 min-w-[120px] sticky left-0 bg-[#f9fafc]">
                    Date
                    </th>
                    <th class="border-b text-left font-medium text-gray-600 px-4 py-3 min-w-[150px] sticky left-[120px] bg-[#f9fafc]">
                    Day
                    </th>
                    @if($classes->count() > 0)
                    @foreach($classes as $class)
                    <th class="border-b text-left font-medium text-gray-600 px-4 py-3 min-w-[200px]">
                        {{$class->name}}
                    </th>
                    @endforeach
                    @endif
                </tr>
                </thead>
                <tbody>
            @if($subjects->count() > 0)
            @foreach($subjects as $index => $subject)
<tr>
    <!-- Date Column (Sticky) -->
    <td class="border-b px-4 py-4 sticky left-0 bg-white">
        @php
            // Get all schedules for this subject across classes
            $subjectSchedules = [];
            foreach ($classes as $class) {
                if (isset($schedulesByClass[$class->id][$index])) {
                    $subjectSchedules[] = $schedulesByClass[$class->id][$index];
                }
            }
            
            // Use the first found schedule as reference
            $schedule = $subjectSchedules[0] ?? null;
        @endphp
        
        @foreach($classes as $class)
            @if(isset($schedulesByClass[$class->id][$index]))
                <input type="hidden" 
                       name="schedules[{{$index}}][classes][{{$class->id}}][sch_id]" 
                       value="{{ $schedulesByClass[$class->id][$index]['id'] }}">
            @endif
        @endforeach
        <input
            name="schedules[{{$index}}][exam_date]"
            type="date"
            value="{{ old("schedules.$index.exam_date", $schedule['exam_date'] ?? date('Y-m-d')) }}"
            class="w-full px-2 py-2 border rounded"
        />
    </td>
    
    <!-- Day Column (Sticky) -->
     

    <td class="border-b px-4 py-4 sticky left-[120px] bg-white">
                @php
                    $day = isset($schedule['exam_date']) 
                           ? \Carbon\Carbon::parse($schedule['exam_date'])->format('l') 
                           : 'Monday';
                @endphp
                <select name="schedules[{{$index}}][exam_day]" class="w-full px-2 py-2 border rounded min-w-[120px]">
                    <option class="truncate" title="Monday" {{ $day == 'Monday' ? 'selected' : '' }}>Monday</option>
                    <option class="truncate" title="Tuesday" {{ $day == 'Tuesday' ? 'selected' : '' }}>Tuesday</option>
                    <option class="truncate" title="Wednesday" {{ $day == 'Wednesday' ? 'selected' : '' }}>Wednesday</option>
                    <option class="truncate" title="Thursday" {{ $day == 'Thursday' ? 'selected' : '' }}>Thursday</option>
                    <option class="truncate" title="Friday" {{ $day == 'Friday' ? 'selected' : '' }}>Friday</option>
                    <option class="truncate" title="Saturday" {{ $day == 'Saturday' ? 'selected' : '' }}>Saturday</option>
                    <option class="truncate" title="Sunday" {{ $day == 'Sunday' ? 'selected' : '' }}>Sunday</option>
                </select>
            </td>
    
    <!-- Class Columns -->
    @foreach($classes as $class)
    <td class="border-b px-4 py-4">
        @php
            $classSchedule = $schedulesByClass[$class->id][$index] ?? null;
            $oldValue = old("schedules.$index.{$class->id}.subject_id");
            $defaultValue = $oldValue ?? ($classSchedule['subject_id'] ?? '');
        @endphp

        <select name="schedules[{{$index}}][{{$class->id}}][subject_id]" class="w-full px-2 py-2 font-semibold border rounded min-w-[150px]">
           <option value="none" {{ $defaultValue === '' ? 'selected' : '' }}>None</option>
                        @foreach($subjects as $subjectOption)
                            <option 
                                value="{{ $subjectOption->id }}" 
                                class="truncate" 
                                title="{{ $subjectOption->name }}"
                                {{ $defaultValue == $subjectOption->id ? 'selected' : '' }}
                            >
                                {{ $subjectOption->name }}
                            </option>
                        @endforeach
        </select>
    </td>
    @endforeach
</tr>
@endforeach
@endif   
                </tbody>
            </table>
        </div>
        </div>
      </div>
    
    <!-- Submit Button -->
    <div class="text-right px-6 my-3 pt-2 pb-2 bg-[#f9fafc]">
      <button
        type="submit"
        class="bg-[#0197FF] text-white px-6 py-2 rounded hover:bg-blue-700"
      >
        Save Timetable
      </button>
    </div>
</form>

@endsection