<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\User;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;
use Illuminate\Support\Facades\Hash;

class SuperAdminSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Super Admin
        $superAdminRole = Role::firstOrCreate(['name' => 'superadmin']);
        $superAdmin = User::updateOrCreate(
            ['email' => 'superadmin@sms.com'],
            [
                'name' => 'Super Admin',
                'password' => Hash::make('password123'),
            ]
        );
        $superAdmin->assignRole($superAdminRole);
        $superAdminRole->syncPermissions(Permission::pluck('name')->toArray());

        // Teacher
        $teacherRole = Role::firstOrCreate(['name' => 'teacher']);
        $teacher = User::updateOrCreate(
            ['email' => 'teacher@sms.com'],
            [
                'name' => 'Teacher User',
                'password' => Hash::make('password123'),
            ]
        );
        $teacher->assignRole($teacherRole);

        // School Admin
        $schoolAdminRole = Role::firstOrCreate(['name' => 'school_admin']);
        $schoolAdmin = User::updateOrCreate(
            ['email' => 'schooladmin@sms.com'],
            [
                'name' => 'School Admin',
                'password' => Hash::make('password123'),
            ]
        );
        $schoolAdmin->assignRole($schoolAdminRole);

        // Student
        $studentRole = Role::firstOrCreate(['name' => 'student']);
        $student = User::updateOrCreate(
            ['email' => 'student@sms.com'],
            [
                'name' => 'Student User',
                'password' => Hash::make('password123'),
            ]
        );
        $student->assignRole($studentRole);

        // Parent
        $parentRole = Role::firstOrCreate(['name' => 'parent']);
        $parent = User::updateOrCreate(
            ['email' => 'parent@sms.com'],
            [
                'name' => 'Parent User',
                'password' => Hash::make('password123'),
            ]
        );
        $parent->assignRole($parentRole);
    }
}
