<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Chart_of_account;

class ChartOfAccountTableSeeder extends Seeder
{
    public function run()
    {
        $accounts = [
            [
                'head_code' => '20500',
                'head_name' => 'cash in hand',
                'account_type' => 'cash in hand',
                'Description' => 'kjk',
                'Status' => 'active',
            ],
            [
                'head_code' => '20400',
                'head_name' => 'income',
                'account_type' => 'income',
                'Description' => 'xkje',
                'Status' => 'active',
            ],
            [
                'head_code' => '20600',
                'head_name' => 'receivable',
                'account_type' => 'receivable',
                'Description' => 'fjkde',
                'Status' => 'active',
            ],
            [
                'head_code' => '20700',
                'head_name' => 'capital',
                'account_type' => 'capital',
                'Description' => 'xkj',
                'Status' => 'active',
            ],
            [
                'head_code' => '20800',
                'head_name' => 'dividend',
                'account_type' => 'dividend',
                'Description' => 'ekjic',
                'Status' => 'active',
            ],
            [
                'head_code' => '20900',
                'head_name' => 'payable',
                'account_type' => 'payable',
                'Description' => 'fkdslf',
                'Status' => 'active',
            ],
            [
                'head_code' => '30100',
                'head_name' => 'bank',
                'account_type' => 'bank',
                'Description' => 'jfkds',
                'Status' => 'active',
            ],
            [
                'head_code' => 'x',
                'head_name' => 'x',
                'account_type' => 'x',
                'Description' => 'x',
            ],
            // Adding 4 extra rows with 'x' value like the last row
            [
                'head_code' => 'x1',
                'head_name' => 'x',
                'account_type' => 'x',
                'Description' => 'x',
            ],
            [
                'head_code' => 'x2',
                'head_name' => 'x',
                'account_type' => 'x',
                'Description' => 'x',
            ],
            [
                'head_code' => 'x3',
                'head_name' => 'x',
                'account_type' => 'x',
                'Description' => 'x',
            ],
            [
                'head_code' => 'x4',
                'head_name' => 'x',
                'account_type' => 'x',
                'Description' => 'x',
            ],
        ];

        foreach ($accounts as $account) {
            Chart_of_account::updateOrCreate(
                ['head_code' => $account['head_code']],
                $account
            );
        }
    }
}
