<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
{
    Schema::table('student_assign_fees', function (Blueprint $table) {
        // Drop foreign keys and columns only if they exist
        $foreignKeys = [
            'admission_fee_id',
            'promotion_fee_id',
            'scholarship_fee_id',
            'sport_fee_id',
            'tuition_fee_id',
            'lab_fee_id',
            'exam_fee_id',
            'board_fee_id',
            'entertainment_fee_id',
            'other_fee_id',
            'books_charges_id',
            'annual_charges_id',
            'second_time_fee_id',
        ];

        foreach ($foreignKeys as $column) {
            if (Schema::hasColumn('student_assign_fees', $column)) {
                try {
                    $table->dropForeign(['' . $column . '']);
                } catch (\Exception $e) {
                    // Foreign key might not exist – ignore
                }
                $table->dropColumn($column);
            }
        }

        // Add new fee columns
        $table->double('admission_fee')->nullable();
        $table->double('promotion_fee')->nullable();
        $table->double('scholarship_fee')->nullable();
        $table->double('sport_fee')->nullable();
        $table->double('tuition_fee')->nullable();
        $table->double('lab_fee')->nullable();
        $table->double('exam_fee')->nullable();
        $table->double('board_fee')->nullable();
        $table->double('entertainment_fee')->nullable();
        $table->double('other_fee')->nullable();
        $table->double('books_charges')->nullable();
        $table->double('annual_charges')->nullable();
        $table->double('second_time_fee')->nullable();
    });
}


    public function down()
    {
        Schema::table('student_assign_fees', function (Blueprint $table) {
            // Revert changes if necessary (optional)
            $table->dropColumn([
                'admission_fee',
                'promotion_fee',
                'scholarship_fee',
                'sport_fee',
                'tuition_fee',
                'lab_fee',
                'exam_fee',
                'board_fee',
                'entertainment_fee',
                'other_fee',
                'books_charges',
                'annual_charges',
                'second_time_fee'
            ]);
        });
    }
};
