<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('exam_hall_assignments', function (Blueprint $table) {
            $table->id(); // Primary key (auto-incrementing BIGINT)
            
            // Identification fields
            $table->string('head_code', 50)->nullable();
            $table->string('reg_no', 50)->nullable();
            $table->string('roll_number', 50);  
            // Foreign keys
            $table->foreignId('exam_schedule_id')->constrained('exam_schedules')->onDelete('cascade');
            $table->foreignId('student_id')->constrained('students')->onDelete('cascade');
            $table->foreignId('exam_hall_id')->constrained('exam_halls')->onDelete('cascade');
            $table->foreignId('exam_id')->constrained('exams')->onDelete('cascade');
            $table->foreignId('invigilator_id')->nullable()->constrained('staff_members')->onDelete('set null');
            
            // Assignment details
            $table->string('seat_number')->nullable();
            
            // Timestamps
            $table->timestamps();
            
            // Indexes for better performance
            $table->index(['exam_schedule_id', 'student_id']);
            $table->index(['exam_hall_id', 'seat_number']);
            $table->index('head_code');
            $table->index('reg_no');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('exam_hall_assignments');
    }
};