<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('exam_halls', function (Blueprint $table) {
            $table->id(); // Primary key (auto-incrementing BIGINT)
            $table->string('name'); // Hall name (e.g., Hall A, Room 101)
            $table->integer('capacity'); // Max number of students
            $table->string('location')->nullable(); // Optional location
            $table->text('notes')->nullable(); // Optional special notes
            $table->timestamps(); // Adds created_at and updated_at columns
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('exam_halls');
    }
};