<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('exams', function (Blueprint $table) {
            $table->id(); // Auto-increment primary key (id)
            $table->string('title', 100); // Exam title
            $table->string('type', 50); // Type of exam
            $table->text('notes')->nullable(); // Additional notes
            $table->string('reg_no')->nullable(); // Registration number (nullable)
            $table->string('head_code')->nullable(); // Head code (nullable)
            $table->timestamps(); // created_at and updated_at timestamps
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('exams');
    }
};