<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('generate_salary', function (Blueprint $table) {
            $table->id(); // Primary key
            $table->engine = 'InnoDB';
            $table->date('date');
            $table->string('month');
            $table->string('year');
            $table->double('total_amount', 10, 2)->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('_generate_salary');
    }
};
