<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateStudentCollectFeeTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('student_collect_fees', function (Blueprint $table) {
            $table->id(); // Unique Record ID (Primary Key)
            $table->engine = 'InnoDB';
            $table->string('head_code'); // Additional field for head code
            $table->string('reg_no');
            $table->foreignId('student_id')->constrained('students')->onDelete('cascade'); // Reference to student
            $table->foreignId('class_id')->constrained('classes')->onDelete('cascade'); // Reference to class
            $table->foreignId('section_id')->constrained('sections')->onDelete('cascade'); // Reference to section
            $table->string('description'); // Type of fee (Tuition, Exam, etc.)
            $table->double('total_amount', 10, 2); // Total amount to be paid
            $table->double('discount', 10, 2)->nullable(); // Discount Amount during admission (optional)
            $table->date('date'); // Date
            $table->string('status'); // Status of payment
            $table->text('remarks')->nullable(); // Notes (if any)
            $table->timestamps(); // Created at and updated at timestamps
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('student_collect_fee');
    }
}
