<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up() {
        Schema::create('staff_career_history', function (Blueprint $table) {
            $table->id();
            $table->engine = 'InnoDB';
            $table->foreignId('staff_member_id')->constrained('staff_members')->onDelete('cascade');
            $table->string('position');
            $table->string('previous_position')->nullable();
            $table->date('promotion_date');
            $table->text('remarks')->nullable();
            $table->enum('status', ['hired', 'promoted', 'transferred', 'resigned']);
            $table->timestamps();
        });
    }

    public function down() {
        Schema::dropIfExists('staff_career_history');
    }
};

