<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddJobIdToJobApplicationsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('job_applications', function (Blueprint $table) {
            // Add the job_id column as a foreign key
            $table->foreignId('job_id')
                  ->constrained('job_positions') // References the job_positions table
                  ->onDelete('cascade'); // Cascade deletes
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('job_applications', function (Blueprint $table) {
            // Drop the foreign key constraint
            $table->dropForeign(['job_id']);
            // Drop the job_id column
            $table->dropColumn('job_id');
        });
    }
}