<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('job_positions', function (Blueprint $table) {
            $table->id();
            $table->engine = 'InnoDB';
            $table->string('title');
            $table->string('category');
            $table->string('qualification_required');
            $table->unsignedTinyInteger('experience_required'); // Ensures positive values and saves space
            $table->unsignedTinyInteger('age'); // Age is always positive
            $table->decimal('salary', 10, 2); // More precise for financial values
            $table->text('description');
            $table->enum('status', ['open', 'closed', 'pending'])->default('open');
            $table->timestamps();
        });
        
    }

    public function down(): void
    {
        Schema::dropIfExists('job_positions');
    }
};

