<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('expense_categories', function (Blueprint $table) {
            $table->id();
            $table->engine = 'InnoDB';
            $table->bigInteger('head_code')->unique(); // Unique code for each expense category
            $table->string('name'); // Name of the expense category
            $table->enum('account_type', ['shortTerm', 'longTerm']); // Type of expense
            $table->text('description')->nullable(); // Description of the expense category
            $table->enum('status', ['active', 'inactive'])->default('Active'); // Status of the expense category
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('expense_categories');
    }
};
