<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up()
    {
        Schema::create('chart_of_accounts', function (Blueprint $table) {
            $table->id();
            $table->engine = 'InnoDB';
            $table->string('head_code')->unique(); // Unique code representing the account
            $table->string('head_name'); // Name of the account
            $table->string('account_type'); // Type of account (e.g., asset, liability, revenue)
            $table->text('description')->nullable(); // Description of the account
            $table->enum('status', ['active', 'inactive'])->default('active'); // Status of the account
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('chart_of_accounts');
    }
};
