<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateStudentFeeDetailsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('student_fee_details', function (Blueprint $table) {
            $table->id(); // Unique fee record ID (Primary Key)
            $table->engine = 'InnoDB';
            $table->foreignId('student_id')->constrained('students')->onDelete('cascade'); // Reference to the student
            $table->string('head_code');
            $table->string('reg_no');
            $table->foreignId('class_id')->constrained('classes')->onDelete('cascade'); // Reference to the class
            $table->foreignId('std_fee_id')->constrained('student_fees')->onDelete('cascade'); // Reference to the class
            $table->string('academic_year'); // Academic year (e.g., "2024-2025")
            $table->string('billing_month', 7)->nullable(); // Month for which the fee is billed (e.g., '2025-03')
            $table->double('admission_fee', 10, 2)->nullable(); // Admission fee amount
            $table->double('promotion_fee', 10, 2)->nullable(); // Promotion fee amount
            $table->double('scholarship_fee', 10, 2)->nullable(); // Scholarship fee amount
            $table->double('sport_fee', 10, 2)->nullable(); // Sport fee
            $table->double('tuition_fee', 10, 2)->nullable(); // Monthly tuition fee
            $table->double('lab_fee', 10, 2)->nullable(); // Lab charges
            $table->double('exam_fee', 10, 2)->nullable(); // Examination fee
            $table->double('board_fee', 10, 2)->nullable(); // Board registration/exam fee
            $table->double('entertainment_fee', 10, 2)->nullable(); // Entertainment charges
            $table->double('other_fee', 10, 2)->nullable(); // Any other additional charges
            $table->double('books_charges', 10, 2)->nullable(); // Books and study materials charges
            $table->double('annual_charges', 10, 2)->nullable(); // Annual maintenance or other charges
            $table->double('second_time_fee', 10, 2)->nullable(); // Fee for re-examinations or additional sessions
            $table->timestamps(); // Record creation date and last update timestamp
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('student_fee_details');
    }
}