<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTransactionDetailsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('transaction_details', function (Blueprint $table) {
            $table->id(); // Unique transaction detail ID (Primary Key)
            $table->engine = 'InnoDB';
            $table->foreignId('transaction_id')->constrained('transactions')->onDelete('cascade'); // Reference to Transactions table
            $table->string('coa_id'); // Account type (e.g., student, employee, etc.)
            $table->string('transaction_type'); // Type of transaction (e.g., Tuition, Exam, Admission Fee)
            $table->double('debit', 10, 2)->nullable(); // Amount deducted from the account
            $table->double('credit', 10, 2)->nullable(); // Amount added to the account
            $table->timestamps(); // Created at and updated at timestamps
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('transaction_details');
    }
}