<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTransactionsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('transactions', function (Blueprint $table) {
            $table->id(); // Unique transaction ID (Primary Key)
            $table->engine = 'InnoDB';
            $table->text('transaction_type'); // Type of transaction
            $table->foreignId('trans_type_id'); // User ID of the user who made the transaction
            $table->date('transaction_date'); // Date of the transaction
            $table->double('total_amount', 10, 2); // Total amount for this transaction
            $table->text('remarks')->nullable(); // Any additional information
            $table->timestamps(); // Created at and updated at timestamps
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('transactions');
    }
}