<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateFeeStructureTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('fee_structures', function (Blueprint $table) {
            $table->id(); // Primary key
            $table->engine = 'InnoDB';
            $table->foreignId('class_id')->constrained('classes')->onDelete('cascade'); // Foreign key to classes table
            $table->string('fee_type'); // Type of fee (e.g., admission, tuition, etc.)
            $table->double('amount', 10, 2)->nullable(); // Amount of the fee
            $table->string('year'); // Academic year (e.g., 2024-2025)
            $table->timestamps(); // created_at and updated_at timestamps
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('fee_structures');
    }
}