<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up()
    {
        Schema::table('students', function (Blueprint $table) {
            $table->string('reg_no')->unique()->nullable()->after('user_id');
            $table->enum('discount_type', ['scholarship', 'siblings', 'poor', 'flat'])->nullable(); // Discount type
            $table->enum('status', ['active', 'promoted', 'completed', 'migrated'])
            ->default('active')
            ->after('discount_type');
                  
        });
    }

    public function down()
    {
        Schema::table('students', function (Blueprint $table) {
            $table->dropColumn(['reg_no', 'discount_type','status']);
        });
    }
};

