<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up()
    {
        Schema::create('student_classes', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->id();
            $table->string('head_code');
            $table->string('reg_no');
            $table->string('academic_year');
            $table->enum('status', ['active', 'promoted', 'completed', 'migrated'])->default('active');
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('student_classes');
    }
};
