<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('job_applications', function (Blueprint $table) {
            $table->id();
            $table->engine = 'InnoDB';
            $table->string('applicant_name');
            $table->string('father_name');
            $table->string('email');
            $table->string('phone');
            $table->text('address');
            $table->string('qualification');
            $table->integer('experience');
            $table->string('applied_position');
            $table->string('resume'); // Stores file path
            $table->text('cover_letter')->nullable();
            $table->enum('apply_type', ['offline', 'online'])->default('online'); // New Column
            $table->enum('application_status', ['pending', 'reviewed', 'accepted', 'rejected'])->default('pending');
            $table->timestamp('applied_date')->useCurrent();
            $table->timestamps();
        });
        
    }

    public function down(): void
    {
        Schema::dropIfExists('job_applications');
    }
};
