<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up()
    {
        Schema::create('staff_members', function (Blueprint $table) {
            $table->id();
            $table->engine = 'InnoDB';
            // Foreign key linking to users table
            $table->foreignId('user_id')
                ->nullable()
                ->constrained('users')
                ->onUpdate('cascade')
                ->onDelete('cascade');
            $table->string('head_code')->nullable();
            $table->string('registration_no')->nullable();
            $table->string('cnic')->nullable();
            $table->string('account_type')->nullable();
              
            // Personal Information
            $table->string('full_name');
            $table->string('father_name')->nullable();
            $table->string('email')->unique();
            $table->date('date_of_birth')->nullable();
            $table->string('address');
            // Contact Information
            $table->string('primary_contact_no');
            $table->string('secondary_contact_no')->nullable();
            
             // Professional Details
            $table->string('position');
            $table->double('salary', 10, 2)->nullable();
            $table->string('employment_type');
            $table->integer('previous_experience')->nullable();
            $table->text('qualifications')->nullable();

            // Document Uploads
            $table->string('profile_photo')->nullable();
            $table->string('cv_resume')->nullable();
            $table->string('transcript')->nullable();
            $table->string('degree_certificate')->nullable();

            // Additional Information
            $table->text('additional_notes')->nullable();

            // Status Column
            $table->enum('status',['active','inactive','resigned'])->nullable();
            $table->date('hire_date')->nullable();
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('staff_members');
    }
};
