<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up()
    {
        Schema::create('new_student_application_guardians', function (Blueprint $table) {
            $table->id();
            $table->engine = 'InnoDB';
            $table->foreignId('student_id')->constrained('new_student_applications')->onDelete('cascade');
            $table->string('guardian_name');
            $table->string('guardian_relationship');
            $table->string('guardian_cnic')->unique();
            $table->string('primary_contact');
            $table->string('alternate_contact')->nullable();
            $table->string('email')->nullable();
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('new_student_application_guardians');
    }
};
