<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up()
    {
        Schema::create('new_student_applications', function (Blueprint $table) {
            $table->id();
            $table->engine = 'InnoDB';
            $table->string('full_name');
            $table->string('father_name');
            $table->date('dob');
            $table->string('gender');
            $table->string('cnic')->unique();
            $table->string('class_applying');
            $table->text('address');
            $table->integer('status')->default(1); // Default status = 1
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('new_student_applications');
    }
};
