<?php

use Illuminate\Foundation\Application;
use Illuminate\Foundation\Configuration\Exceptions;
use Illuminate\Foundation\Configuration\Middleware;
use App\Http\Middleware\RoleMiddleware;
use App\Http\Middleware\CheckPermission;

$app = Application::configure(basePath: dirname(__DIR__))
    ->withRouting(
        web: __DIR__.'/../routes/web.php',
        api: __DIR__.'/../routes/api.php',
        commands: __DIR__.'/../routes/console.php',
        health: '/up',
    )
    ->withMiddleware(function (Middleware $middleware) {
        $middleware->alias([
            'role' => RoleMiddleware::class,
            'permission' => CheckPermission::class, // ✅ add here
        ]);
    })
    ->withExceptions(function (Exceptions $exceptions) {
        //
    });

/**
 * ✅ Register global helper BEFORE ->create()
 */
require_once app_path('Support/helpers.php');

/**
 * ✅ Now call create()
 */
return $app->create();
