<?php
use App\Models\Role;

if (!function_exists('userHasPermission')) {
    function userHasPermission($permissionName): bool
    {
        $user = auth()->user();
        if (!$user) return false;

        $role = Role::where('name', $user->role)->first();

        if (!$role) return false;

        return $role->permissions()->where('name', $permissionName)->exists();
    }
}
