<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Student extends Model
{
    use HasFactory;

    protected $guarded = [];

    // Relationships
    public function guardian()
    {
        return $this->hasOne(Guardian::class);
    }

    public function previousEducation()
    {
        return $this->hasOne(Previous_education::class, 'student_id');
    }

    public function emergencyContact()
    {
        return $this->hasOne(Emergency_contact::class);
    }

    public function documents()
    {
        return $this->hasOne(Document::class, 'student_id');
    }

    public function student_classes()
    {
        return $this->hasMany(Student_classe::class);
    }

    public function latestStudentClass()
    {
        return $this->hasOne(Student_classe::class)->latest();
    }
    
  // Relationship with classes through student_classes
  public function classes()
  {
      return $this->hasManyThrough(Classe::class, Student_classe::class, 'student_id', 'id', 'id', 'class_id');
  }
  public function sections()
  {
      return $this->hasManyThrough(Section::class, Student_classe::class, 'student_id', 'id', 'id', 'section_id');
  }

       // Relationship with admissions
    public function admissions()
    {
        return $this->hasMany(Admission::class);
    }

    // Get the latest admission (new or repeated)
    public function latestAdmission()
    {
        return $this->hasOne(Admission::class, 'student_id', 'id')->latest();
    }
    public function admissionHistory()
    {
        return $this->hasMany(AdmissionHistory::class);
    }
    // Get a specific admission (e.g., new or repeated)
    public function specificAdmission($type)
    {
        return $this->hasOne(Admission::class)->where('admission_status', $type)->latest();
    }

    // app/Models/Student.php
    public function assignedFees()
    {
        return $this->hasMany(Student_assign_fee::class);
    }

    public function latestAssignedFee()
    {
        return $this->hasOne(Student_assign_fee::class, 'student_id', 'id')->latest();
    }
    // Student.php
    public function attendances()
    {
        return $this->hasMany(Attendance::class);
    }

    public function hallAssignments()
    {
        return $this->hasMany(ExamHallAssignment::class);
    }

    public function rollNumbers()
    {
        return $this->hasMany(ExamRollNumber::class);
    }
    public function fees()
    {
        return $this->hasMany(Student_fee::class, 'student_id');
    }

}
