<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Staff_member extends Model
{
    protected $guarded = [];

    public function job_position()
    {
        return $this->belongsTo(Job_position::class, 'position');
    }

    // has many teacher_timetables
    public function teacher_timetables()
    {
        return $this->hasMany(teacher_timetable::class, 'teacher_id', 'id');
    }

    // ✅ Staff has many attendances
    public function attendances()
    {
        return $this->hasMany(Staff_attendance::class, 'staff_id', 'id'); // ✅ Correct
    }

    public function salaryDetails()
    {
        return $this->hasMany(Generate_salary_detail::class, 'staff_id');
    }

    // Staff_member.php
    public function salaryStruct()
    {
        return $this->hasOne(Staff_salary_struct::class, 'staff_id')->latestOfMany();
    }
    public function salary_Pay_Detail()
    {
        return $this->hasMany(Salary_pay_detail::class, 'staff_id');
    }
    
}
