<?php

namespace App\Http\Controllers;

use App\Models\Student;
use App\Models\Transaction_detail;
use Illuminate\Http\Request;
use Barryvdh\DomPDF\Facade\Pdf;
class StudentLedgerController extends Controller
{
    public function stdLedger()
    {
        $stdLedger = collect();
        $stdOpenBalance = 0;
        $stdList = Student::select('head_code', 'student_name', 'reg_no', 'status')->get();
        return view('student.stdledger', compact('stdLedger','stdList', 'stdOpenBalance'));
    }

    public function getLedger(Request $request)
    {
        $request->validate([
            'head_code' => 'required',
            'start_date' => 'required|date|before_or_equal:end_date',
            'end_date' => 'required|date|after_or_equal:start_date',
        ]);

        $head_code = $request->input('head_code');
        $startDate = $request->input('start_date');
        $endDate = $request->input('end_date');
        $stdList = Student::select('head_code', 'student_name', 'reg_no', 'status')->get();
        $stdRec = Student::where('head_code', $head_code)->first();
        if ($stdRec) {
            $stdName = $stdRec->student_name;
            $fthName = $stdRec->father_name;
            $fthCnic = $stdRec->father_cnic;
            $regNo = $stdRec->reg_no;

            $stdOpenBalance = Transaction_detail::where('coa_id', $head_code)
                ->where('created_at', '<', $startDate)
                ->selectRaw('SUM(debit) - SUM(credit) as balance')
                ->value('balance') ?? 0;

            $stdLedger = Transaction_detail::where('coa_id', $head_code)
                ->whereBetween('created_at', [$startDate, $endDate])
                ->get();
        } else {
            $stdName = "No Record";
            $fthName = "No Record";
            $fthCnic = "No Record";
            $stdOpenBalance = 0;
            $stdLedger = collect(); // prevent null errors
        }

        return view('student.stdledger', compact(
            'regNo',
            'startDate',
            'endDate',
            'stdName',
            'fthName',
            'fthCnic',
            'stdOpenBalance',
            'stdLedger',
            'stdList',
        ));
    }

    public function pdfStudentLedger(Request $request)
    {
        $request->validate([
            'head_code' => 'required',
            'start_date' => 'required|date|before_or_equal:end_date',
            'end_date' => 'required|date|after_or_equal:start_date',
        ]);

        $head_code = $request->input('head_code');
        $startDate = $request->input('start_date');
        $endDate = $request->input('end_date');

        $stdRec = Student::where('head_code', $head_code)->first();

        if (!$stdRec) {
            return redirect()->back()->with('error', 'Student not found.');
        }

        $stdName = $stdRec->student_name;
        $fthName = $stdRec->father_name;
        $fthCnic = $stdRec->father_cnic;
        $regNo = $stdRec->reg_no;

        $stdOpenBalance = Transaction_detail::where('coa_id', $head_code)
            ->where('created_at', '<', $startDate)
            ->selectRaw('SUM(debit) - SUM(credit) as balance')
            ->value('balance') ?? 0;

        $stdLedger = Transaction_detail::where('coa_id', $head_code)
            ->whereBetween('created_at', [$startDate, $endDate])
            ->get();

        $pdf = PDF::loadView('student.pdfStudentLedger', compact(
            'regNo',
            'startDate',
            'endDate',
            'stdName',
            'fthName',
            'fthCnic',
            'stdOpenBalance',
            'stdLedger'
        ));

        return $pdf->download('student_ledger.pdf');
    }
}
