<?php

namespace App\Http\Controllers;

use App\Models\Staff_member;
use App\Models\Transaction_detail;
use Illuminate\Http\Request;
use Barryvdh\DomPDF\Facade\Pdf;
class StaffLedgerController extends Controller
{
    public function staffLedger()
    {
        $staffs = $this->getActiveStaffs();
        $staffLedger = collect();
        $staffOpenBalance = 0;
        return view('staff.staffLedger', compact('staffs', 'staffLedger', 'staffOpenBalance'));
    }

    public function getLedger(Request $request)
    {
        $request->validate([
            'head_code'   => 'required',
            'start_date'  => 'required|date|before_or_equal:end_date',
            'end_date'    => 'required|date|after_or_equal:start_date',
        ]);
        
        $hc = $request->input('head_code');
        $start_date = $request->input('start_date');
        $end_date = $request->input('end_date');
        $staffs = $this->getActiveStaffs();

        $staffRec = Staff_member::where('head_code', $hc)->first();
        if ($staffRec) {
            $staffName = $staffRec->full_name;
            $regNo = $staffRec->registration_no;
            $cnic = $staffRec->cnic;
            $fthName = $staffRec->father_name;

            $hasExist = Transaction_detail::where('coa_id', $hc)->exists();

            if ($hasExist) {
                $staffOpenBalance = Transaction_detail::where('coa_id', $hc)
                    ->where('created_at', '<', $start_date)
                    ->selectRaw('SUM(debit) - SUM(credit) as balance')
                    ->value('balance') ?? 0;

                $staffLedger = Transaction_detail::where('coa_id', $hc)
                    ->whereBetween('created_at', [$start_date, $end_date])
                    ->get();
            } else {
                // Optional: show alert or set flag for UI
                $staffOpenBalance = 0;
                $staffLedger = collect(); // no transactions
            }
        } else {
            $staffName = "No Record";
            $fthName = "No Record";
            $cnic = "No Record";
            $staffOpenBalance = 0;
            $staffLedger = collect(); // prevent null errors
        }

        return view('staff.staffLedger', compact(
            'regNo',
            'start_date',
            'end_date',
            'staffName',
            'fthName',
            'cnic',
            'staffOpenBalance',
            'staffLedger',
            'staffs'
        ));
    }

    private function getActiveStaffs()
    {
        return Staff_member::select('head_code', 'full_name')
            ->where('status', 'active')
            ->get();
    }

    public function pdfStaffLedger(Request $request)
    {
        $request->validate([
            'head_code'   => 'required',
            'start_date'  => 'required|date|before_or_equal:end_date',
            'end_date'    => 'required|date|after_or_equal:start_date',
        ]);

        $hc = $request->input('head_code');
        $start_date = $request->input('start_date');
        $end_date = $request->input('end_date');

        $staffRec = Staff_member::where('head_code', $hc)->first();

        if (!$staffRec) {
            return redirect()->back()->with('error', 'Staff not found.');
        }

        $staffName = $staffRec->full_name;
        $regNo = $staffRec->registration_no;
        $cnic = $staffRec->cnic;
        $fthName = $staffRec->father_name;

        $staffOpenBalance = Transaction_detail::where('coa_id', $hc)
            ->where('created_at', '<', $start_date)
            ->selectRaw('SUM(debit) - SUM(credit) as balance')
            ->value('balance') ?? 0;

        $staffLedger = Transaction_detail::where('coa_id', $hc)
            ->whereBetween('created_at', [$start_date, $end_date])
            ->get();

        $pdf = PDF::loadView('staff.pdfStaffLedger', compact(
            'regNo',
            'start_date',
            'end_date',
            'staffName',
            'fthName',
            'cnic',
            'staffOpenBalance',
            'staffLedger'
        ));

        return $pdf->download('staff_ledger.pdf');
    }
}
