<?php

namespace App\Http\Controllers;

use App\Models\Income_category;
use Illuminate\Http\Request;

class IncomeCatgController extends Controller
{
    public function show()
    {
        $categories = Income_category::latest()->paginate(10);
        return view('income.income-category', compact('categories'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'description' => 'nullable|string',
        ]);

        // Access data
        $name = $request->input('name');
        $description = $request->input('description');

        $max_id    = Income_category::max('id');
        $head_code = 30300 + ($max_id == null ? 1 : $max_id + 1);

        // Save to DB (optional)
        Income_category::create([
            'head_code' =>  $head_code,
            'name' => $name,
            'account_type' => "longTerm", // i will delete this column because this is not needed
            'description' => $description,
        ]);

        return redirect()->back()->with('success', 'Income Category created successfully!');
    }
}
