<?php

namespace App\Http\Controllers;

use App\Models\Classe;
use App\Models\Student;
use App\Models\Student_assign_fee;
use Illuminate\Http\Request;
use Barryvdh\DomPDF\Facade\Pdf;
class EditStudentAssignFeeController extends Controller
{

    public function index(Request $request)
    {
        $stdList = Student::select('head_code', 'student_name', 'reg_no')->where('status', 'active')->get();
        $classList = Classe::select('id', 'name')->get();
        $query = Student_assign_fee::with(['student', 'class'])
            ->orderBy('id', 'desc');


        if ($request->filled('search')) {
            $query->where(function ($q) use ($request) {
                $q->where('reg_no',  $request->search)
                    ->orWhere('head_code', $request->search)
                    ->orWhere('class_id', $request->search);
            });
        }

        if ($request->filled('class_search')) {
            $query->where(function ($q) use ($request) {
                $q->where('class_id', $request->class_search);
            });
        }


        $fees = $query->paginate($request->get('entries', 40)); // default to 10

        if ($request->ajax()) {
            return view('stdFeeMgt.partial-edit-student-assign-fee', compact('fees'))->render();
        }

        return view('stdFeeMgt.edit-student-assign-fee', compact('fees', 'stdList', 'classList'));
    }



    public function pdfEditStudentAssignFee(Request $request)
    {
        $query = Student_assign_fee::with(['student', 'class'])->orderBy('id', 'desc');

        if ($request->filled('search')) {
            $query->where(function ($q) use ($request) {
                $q->where('reg_no',  $request->search)
                    ->orWhere('head_code', $request->search)
                    ->orWhere('class_id', $request->search);
            });
        }

        if ($request->filled('class_search')) {
            $query->where('class_id', $request->class_search);
        }

        // No pagination for PDF
        $fees = $query->get();

        $pdf = Pdf::loadView('stdFeeMgt.pdfEditStudentAssignFee', compact('fees'))->setPaper('a4', 'landscape');

        return $pdf->download('Student_Assign_Fee_Report.pdf');
    }


    public function update(Request $request)
    {
        $fee = Student_assign_fee::findOrFail($request->id);

        $fee->update([
            'admission_fee'      => $request->admission_fee,
            'promotion_fee'      => $request->promotion_fee,
            'scholarship_fee'    => null,
            'sport_fee'          => null,
            'tuition_fee'        => $request->tuition_fee,
            'lab_fee'            => $request->lab_fee,
            'exam_fee'           => $request->exam_fee,
            'board_fee'          => $request->board_fee,
            'entertainment_fee'  => $request->entertainment_fee,
            'other_fee'          => $request->other_fee,
            'books_charges'       => $request->book_charges,
            'annual_charges'     => $request->annual_charges,
            'second_time_fee'    => $request->second_time_fee,
        ]);

        return redirect()->back()->with('success', 'Student fee updated successfully.');
    }
}
